/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Places uses a point geometry to specify a location or a Place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlaceGeometry implements SdkPojo, Serializable, ToCopyableBuilder<PlaceGeometry.Builder, PlaceGeometry> {
    private static final SdkField<List<Double>> POINT_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Point")
            .getter(getter(PlaceGeometry::point))
            .setter(setter(Builder::point))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Point").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> point;

    private PlaceGeometry(BuilderImpl builder) {
        this.point = builder.point;
    }

    /**
     * For responses, this returns true if the service returned a value for the Point property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPoint() {
        return point != null && !(point instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A single point geometry specifies a location for a Place using <a
     * href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>x</i> — Specifies the x coordinate or longitude.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>y</i> — Specifies the y coordinate or latitude.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPoint} method.
     * </p>
     * 
     * @return A single point geometry specifies a location for a Place using <a
     *         href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>x</i> — Specifies the x coordinate or longitude.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>y</i> — Specifies the y coordinate or latitude.
     *         </p>
     *         </li>
     */
    public final List<Double> point() {
        return point;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPoint() ? point() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaceGeometry)) {
            return false;
        }
        PlaceGeometry other = (PlaceGeometry) obj;
        return hasPoint() == other.hasPoint() && Objects.equals(point(), other.point());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlaceGeometry").add("Point", point() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Point":
            return Optional.ofNullable(clazz.cast(point()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Point", POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlaceGeometry, T> g) {
        return obj -> g.apply((PlaceGeometry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlaceGeometry> {
        /**
         * <p>
         * A single point geometry specifies a location for a Place using <a
         * href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>x</i> — Specifies the x coordinate or longitude.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>y</i> — Specifies the y coordinate or latitude.
         * </p>
         * </li>
         * </ul>
         * 
         * @param point
         *        A single point geometry specifies a location for a Place using <a
         *        href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>x</i> — Specifies the x coordinate or longitude.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>y</i> — Specifies the y coordinate or latitude.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder point(Collection<Double> point);

        /**
         * <p>
         * A single point geometry specifies a location for a Place using <a
         * href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>x</i> — Specifies the x coordinate or longitude.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>y</i> — Specifies the y coordinate or latitude.
         * </p>
         * </li>
         * </ul>
         * 
         * @param point
         *        A single point geometry specifies a location for a Place using <a
         *        href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>x</i> — Specifies the x coordinate or longitude.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>y</i> — Specifies the y coordinate or latitude.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder point(Double... point);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> point = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlaceGeometry model) {
            point(model.point);
        }

        public final Collection<Double> getPoint() {
            if (point instanceof SdkAutoConstructList) {
                return null;
            }
            return point;
        }

        public final void setPoint(Collection<Double> point) {
            this.point = PositionCopier.copy(point);
        }

        @Override
        public final Builder point(Collection<Double> point) {
            this.point = PositionCopier.copy(point);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder point(Double... point) {
            point(Arrays.asList(point));
            return this;
        }

        @Override
        public PlaceGeometry build() {
            return new PlaceGeometry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
