/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForSuggestionsResponse extends LocationResponse implements
        ToCopyableBuilder<SearchPlaceIndexForSuggestionsResponse.Builder, SearchPlaceIndexForSuggestionsResponse> {
    private static final SdkField<SearchPlaceIndexForSuggestionsSummary> SUMMARY_FIELD = SdkField
            .<SearchPlaceIndexForSuggestionsSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(SearchPlaceIndexForSuggestionsResponse::summary)).setter(setter(Builder::summary))
            .constructor(SearchPlaceIndexForSuggestionsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<SearchForSuggestionsResult>> RESULTS_FIELD = SdkField
            .<List<SearchForSuggestionsResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SearchPlaceIndexForSuggestionsResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchForSuggestionsResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchForSuggestionsResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SearchPlaceIndexForSuggestionsSummary summary;

    private final List<SearchForSuggestionsResult> results;

    private SearchPlaceIndexForSuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.results = builder.results;
    }

    /**
     * <p>
     * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also
     * includes the <code>DataSource</code> of the place index.
     * </p>
     * 
     * @return Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
     *         <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>,
     *         and <code>Text</code>. Also includes the <code>DataSource</code> of the place index.
     */
    public final SearchPlaceIndexForSuggestionsSummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of place suggestions that best match the search text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A list of place suggestions that best match the search text.
     */
    public final List<SearchForSuggestionsResult> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForSuggestionsResponse)) {
            return false;
        }
        SearchPlaceIndexForSuggestionsResponse other = (SearchPlaceIndexForSuggestionsResponse) obj;
        return Objects.equals(summary(), other.summary()) && hasResults() == other.hasResults()
                && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForSuggestionsResponse").add("Summary", summary())
                .add("Results", hasResults() ? results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Summary", SUMMARY_FIELD);
        map.put("Results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForSuggestionsResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForSuggestionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchPlaceIndexForSuggestionsResponse> {
        /**
         * <p>
         * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and
         * <code>Text</code>. Also includes the <code>DataSource</code> of the place index.
         * </p>
         * 
         * @param summary
         *        Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         *        <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>,
         *        and <code>Text</code>. Also includes the <code>DataSource</code> of the place index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SearchPlaceIndexForSuggestionsSummary summary);

        /**
         * <p>
         * Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and
         * <code>Text</code>. Also includes the <code>DataSource</code> of the place index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SearchPlaceIndexForSuggestionsSummary.Builder} avoiding the need to create one manually via
         * {@link SearchPlaceIndexForSuggestionsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchPlaceIndexForSuggestionsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(SearchPlaceIndexForSuggestionsSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SearchPlaceIndexForSuggestionsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SearchPlaceIndexForSuggestionsSummary)
         */
        default Builder summary(Consumer<SearchPlaceIndexForSuggestionsSummary.Builder> summary) {
            return summary(SearchPlaceIndexForSuggestionsSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * A list of place suggestions that best match the search text.
         * </p>
         * 
         * @param results
         *        A list of place suggestions that best match the search text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SearchForSuggestionsResult> results);

        /**
         * <p>
         * A list of place suggestions that best match the search text.
         * </p>
         * 
         * @param results
         *        A list of place suggestions that best match the search text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SearchForSuggestionsResult... results);

        /**
         * <p>
         * A list of place suggestions that best match the search text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.SearchForSuggestionsResult.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.location.model.SearchForSuggestionsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.SearchForSuggestionsResult.Builder#build()} is called
         * immediately and its result is passed to {@link #results(List<SearchForSuggestionsResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.SearchForSuggestionsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<SearchForSuggestionsResult>)
         */
        Builder results(Consumer<SearchForSuggestionsResult.Builder>... results);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private SearchPlaceIndexForSuggestionsSummary summary;

        private List<SearchForSuggestionsResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForSuggestionsResponse model) {
            super(model);
            summary(model.summary);
            results(model.results);
        }

        public final SearchPlaceIndexForSuggestionsSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(SearchPlaceIndexForSuggestionsSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForSuggestionsSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<SearchForSuggestionsResult.Builder> getResults() {
            List<SearchForSuggestionsResult.Builder> result = SearchForSuggestionsResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SearchForSuggestionsResult.BuilderImpl> results) {
            this.results = SearchForSuggestionsResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<SearchForSuggestionsResult> results) {
            this.results = SearchForSuggestionsResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForSuggestionsResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForSuggestionsResult.Builder>... results) {
            results(Stream.of(results).map(c -> SearchForSuggestionsResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchPlaceIndexForSuggestionsResponse build() {
            return new SearchPlaceIndexForSuggestionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
