/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrackerRequest extends LocationRequest implements
        ToCopyableBuilder<UpdateTrackerRequest.Builder, UpdateTrackerRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(UpdateTrackerRequest::trackerName)).setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(UpdateTrackerRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(UpdateTrackerRequest::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateTrackerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositionFiltering").getter(getter(UpdateTrackerRequest::positionFilteringAsString))
            .setter(setter(Builder::positionFiltering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()).build();

    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EventBridgeEnabled").getter(getter(UpdateTrackerRequest::eventBridgeEnabled))
            .setter(setter(Builder::eventBridgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build())
            .build();

    private static final SdkField<Boolean> KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KmsKeyEnableGeospatialQueries")
            .getter(getter(UpdateTrackerRequest::kmsKeyEnableGeospatialQueries))
            .setter(setter(Builder::kmsKeyEnableGeospatialQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyEnableGeospatialQueries")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, DESCRIPTION_FIELD, POSITION_FILTERING_FIELD,
            EVENT_BRIDGE_ENABLED_FIELD, KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackerName;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final String description;

    private final String positionFiltering;

    private final Boolean eventBridgeEnabled;

    private final Boolean kmsKeyEnableGeospatialQueries;

    private UpdateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.description = builder.description;
        this.positionFiltering = builder.positionFiltering;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
    }

    /**
     * <p>
     * The name of the tracker resource to update.
     * </p>
     * 
     * @return The name of the tracker resource to update.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * This parameter is no longer used.
     * </p>
     * 
     * @return This parameter is no longer used.
     * @deprecated Deprecated. No longer allowed.
     */
    @Deprecated
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * <p>
     * Updates the description for the tracker resource.
     * </p>
     * 
     * @return Updates the description for the tracker resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device
     * trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Updates the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this distance are neither evaluated against linked geofence collections,
     *         nor stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control costs by reducing the number of
     *         geofence evaluations.
     *         </p>
     *         </li>
     * @see PositionFiltering
     */
    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(positionFiltering);
    }

    /**
     * <p>
     * Updates the position filtering for the tracker resource.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
     * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds
     * is stored for each unique device ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This
     * helps control costs by reducing the number of geofence evaluations and historical device positions to paginate
     * through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on
     * a map.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
     * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the
     * second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated
     * against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device
     * trajectories on a map, and can help control costs by reducing the number of geofence evaluations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positionFiltering}
     * will return {@link PositionFiltering#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionFilteringAsString}.
     * </p>
     * 
     * @return Updates the position filtering for the tracker resource.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
     *         every location update is stored. If your update frequency is more often than 30 seconds, only one update
     *         per 30 seconds is stored for each unique device ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
     *         ignored. Location updates within this distance are neither evaluated against linked geofence collections,
     *         nor stored. This helps control costs by reducing the number of geofence evaluations and historical device
     *         positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when
     *         displaying device trajectories on a map.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
     *         are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and
     *         10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are
     *         neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS
     *         noise when displaying device trajectories on a map, and can help control costs by reducing the number of
     *         geofence evaluations.
     *         </p>
     *         </li>
     * @see PositionFiltering
     */
    public final String positionFilteringAsString() {
        return positionFiltering;
    }

    /**
     * <p>
     * Whether to enable position <code>UPDATE</code> events from this tracker to be sent to EventBridge.
     * </p>
     * <note>
     * <p>
     * You do not need enable this feature to get <code>ENTER</code> and <code>EXIT</code> events for geofences with
     * this tracker. Those events are always sent to EventBridge.
     * </p>
     * </note>
     * 
     * @return Whether to enable position <code>UPDATE</code> events from this tracker to be sent to EventBridge.</p>
     *         <note>
     *         <p>
     *         You do not need enable this feature to get <code>ENTER</code> and <code>EXIT</code> events for geofences
     *         with this tracker. Those events are always sent to EventBridge.
     *         </p>
     */
    public final Boolean eventBridgeEnabled() {
        return eventBridgeEnabled;
    }

    /**
     * <p>
     * Enables <code>GeospatialQueries</code> for a tracker that uses a <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS customer
     * managed key</a>.
     * </p>
     * <p>
     * This parameter is only used if you are using a KMS customer managed key.
     * </p>
     * 
     * @return Enables <code>GeospatialQueries</code> for a tracker that uses a <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
     *         customer managed key</a>.</p>
     *         <p>
     *         This parameter is only used if you are using a KMS customer managed key.
     */
    public final Boolean kmsKeyEnableGeospatialQueries() {
        return kmsKeyEnableGeospatialQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyEnableGeospatialQueries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrackerRequest)) {
            return false;
        }
        UpdateTrackerRequest other = (UpdateTrackerRequest) obj;
        return Objects.equals(trackerName(), other.trackerName())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource())
                && Objects.equals(description(), other.description())
                && Objects.equals(positionFilteringAsString(), other.positionFilteringAsString())
                && Objects.equals(eventBridgeEnabled(), other.eventBridgeEnabled())
                && Objects.equals(kmsKeyEnableGeospatialQueries(), other.kmsKeyEnableGeospatialQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrackerRequest").add("TrackerName", trackerName())
                .add("PricingPlan", pricingPlanAsString()).add("PricingPlanDataSource", pricingPlanDataSource())
                .add("Description", description()).add("PositionFiltering", positionFilteringAsString())
                .add("EventBridgeEnabled", eventBridgeEnabled())
                .add("KmsKeyEnableGeospatialQueries", kmsKeyEnableGeospatialQueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PositionFiltering":
            return Optional.ofNullable(clazz.cast(positionFilteringAsString()));
        case "EventBridgeEnabled":
            return Optional.ofNullable(clazz.cast(eventBridgeEnabled()));
        case "KmsKeyEnableGeospatialQueries":
            return Optional.ofNullable(clazz.cast(kmsKeyEnableGeospatialQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("PricingPlanDataSource", PRICING_PLAN_DATA_SOURCE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PositionFiltering", POSITION_FILTERING_FIELD);
        map.put("EventBridgeEnabled", EVENT_BRIDGE_ENABLED_FIELD);
        map.put("KmsKeyEnableGeospatialQueries", KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrackerRequest, T> g) {
        return obj -> g.apply((UpdateTrackerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrackerRequest> {
        /**
         * <p>
         * The name of the tracker resource to update.
         * </p>
         * 
         * @param trackerName
         *        The name of the tracker resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. If included, the only allowed value is RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * This parameter is no longer used.
         * </p>
         * 
         * @param pricingPlanDataSource
         *        This parameter is no longer used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Deprecated. No longer allowed.
         */
        @Deprecated
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * Updates the description for the tracker resource.
         * </p>
         * 
         * @param description
         *        Updates the description for the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
         * This helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when
         * displaying device trajectories on a map, and can help control costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param positionFiltering
         *        Updates the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this distance are neither evaluated against linked geofence
         *        collections, nor stored. This helps control costs by reducing the number of geofence evaluations and
         *        historical device positions to paginate through. Distance-based filtering can also reduce the effects
         *        of GPS noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This helps educe the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(String positionFiltering);

        /**
         * <p>
         * Updates the position filtering for the tracker resource.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every
         * location update is stored. If your update frequency is more often than 30 seconds, only one update per 30
         * seconds is stored for each unique device ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored.
         * Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
         * This helps control costs by reducing the number of geofence evaluations and historical device positions to
         * paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device
         * trajectories on a map.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are
         * ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
         * the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither
         * evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when
         * displaying device trajectories on a map, and can help control costs by reducing the number of geofence
         * evaluations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param positionFiltering
         *        Updates the position filtering for the tracker resource.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not
         *        every location update is stored. If your update frequency is more often than 30 seconds, only one
         *        update per 30 seconds is stored for each unique device ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
         *        ignored. Location updates within this distance are neither evaluated against linked geofence
         *        collections, nor stored. This helps control costs by reducing the number of geofence evaluations and
         *        historical device positions to paginate through. Distance-based filtering can also reduce the effects
         *        of GPS noise when displaying device trajectories on a map.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates
         *        are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m
         *        and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location
         *        updates are neither evaluated against linked geofence collections, nor stored. This helps educe the
         *        effects of GPS noise when displaying device trajectories on a map, and can help control costs by
         *        reducing the number of geofence evaluations.
         *        </p>
         *        </li>
         * @see PositionFiltering
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionFiltering
         */
        Builder positionFiltering(PositionFiltering positionFiltering);

        /**
         * <p>
         * Whether to enable position <code>UPDATE</code> events from this tracker to be sent to EventBridge.
         * </p>
         * <note>
         * <p>
         * You do not need enable this feature to get <code>ENTER</code> and <code>EXIT</code> events for geofences with
         * this tracker. Those events are always sent to EventBridge.
         * </p>
         * </note>
         * 
         * @param eventBridgeEnabled
         *        Whether to enable position <code>UPDATE</code> events from this tracker to be sent to EventBridge.</p>
         *        <note>
         *        <p>
         *        You do not need enable this feature to get <code>ENTER</code> and <code>EXIT</code> events for
         *        geofences with this tracker. Those events are always sent to EventBridge.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeEnabled(Boolean eventBridgeEnabled);

        /**
         * <p>
         * Enables <code>GeospatialQueries</code> for a tracker that uses a <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         * customer managed key</a>.
         * </p>
         * <p>
         * This parameter is only used if you are using a KMS customer managed key.
         * </p>
         * 
         * @param kmsKeyEnableGeospatialQueries
         *        Enables <code>GeospatialQueries</code> for a tracker that uses a <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         *        customer managed key</a>.</p>
         *        <p>
         *        This parameter is only used if you are using a KMS customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String trackerName;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private String description;

        private String positionFiltering;

        private Boolean eventBridgeEnabled;

        private Boolean kmsKeyEnableGeospatialQueries;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrackerRequest model) {
            super(model);
            trackerName(model.trackerName);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            description(model.description);
            positionFiltering(model.positionFiltering);
            eventBridgeEnabled(model.eventBridgeEnabled);
            kmsKeyEnableGeospatialQueries(model.kmsKeyEnableGeospatialQueries);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPositionFiltering() {
            return positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final Boolean getKmsKeyEnableGeospatialQueries() {
            return kmsKeyEnableGeospatialQueries;
        }

        public final void setKmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrackerRequest build() {
            return new UpdateTrackerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
