/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteGeofenceRequest extends LocationRequest implements
        ToCopyableBuilder<BatchDeleteGeofenceRequest.Builder, BatchDeleteGeofenceRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(BatchDeleteGeofenceRequest::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()).build();

    private static final SdkField<List<String>> GEOFENCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GeofenceIds")
            .getter(getter(BatchDeleteGeofenceRequest::geofenceIds))
            .setter(setter(Builder::geofenceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            GEOFENCE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collectionName;

    private final List<String> geofenceIds;

    private BatchDeleteGeofenceRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.geofenceIds = builder.geofenceIds;
    }

    /**
     * <p>
     * The geofence collection storing the geofences to be deleted.
     * </p>
     * 
     * @return The geofence collection storing the geofences to be deleted.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeofenceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeofenceIds() {
        return geofenceIds != null && !(geofenceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The batch of geofences to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeofenceIds} method.
     * </p>
     * 
     * @return The batch of geofences to be deleted.
     */
    public final List<String> geofenceIds() {
        return geofenceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeofenceIds() ? geofenceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteGeofenceRequest)) {
            return false;
        }
        BatchDeleteGeofenceRequest other = (BatchDeleteGeofenceRequest) obj;
        return Objects.equals(collectionName(), other.collectionName()) && hasGeofenceIds() == other.hasGeofenceIds()
                && Objects.equals(geofenceIds(), other.geofenceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteGeofenceRequest").add("CollectionName", collectionName())
                .add("GeofenceIds", hasGeofenceIds() ? geofenceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "GeofenceIds":
            return Optional.ofNullable(clazz.cast(geofenceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("GeofenceIds", GEOFENCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteGeofenceRequest, T> g) {
        return obj -> g.apply((BatchDeleteGeofenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteGeofenceRequest> {
        /**
         * <p>
         * The geofence collection storing the geofences to be deleted.
         * </p>
         * 
         * @param collectionName
         *        The geofence collection storing the geofences to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The batch of geofences to be deleted.
         * </p>
         * 
         * @param geofenceIds
         *        The batch of geofences to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceIds(Collection<String> geofenceIds);

        /**
         * <p>
         * The batch of geofences to be deleted.
         * </p>
         * 
         * @param geofenceIds
         *        The batch of geofences to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceIds(String... geofenceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String collectionName;

        private List<String> geofenceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteGeofenceRequest model) {
            super(model);
            collectionName(model.collectionName);
            geofenceIds(model.geofenceIds);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final Collection<String> getGeofenceIds() {
            if (geofenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return geofenceIds;
        }

        public final void setGeofenceIds(Collection<String> geofenceIds) {
            this.geofenceIds = BatchDeleteGeofenceRequestGeofenceIdsListCopier.copy(geofenceIds);
        }

        @Override
        public final Builder geofenceIds(Collection<String> geofenceIds) {
            this.geofenceIds = BatchDeleteGeofenceRequestGeofenceIdsListCopier.copy(geofenceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geofenceIds(String... geofenceIds) {
            geofenceIds(Arrays.asList(geofenceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteGeofenceRequest build() {
            return new BatchDeleteGeofenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
