/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the calculated route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculateRouteSummary.Builder, CalculateRouteSummary> {
    private static final SdkField<List<Double>> ROUTE_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("RouteBBox")
            .getter(getter(CalculateRouteSummary::routeBBox))
            .setter(setter(Builder::routeBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(CalculateRouteSummary::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Double> DISTANCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Distance").getter(getter(CalculateRouteSummary::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Double> DURATION_SECONDS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DurationSeconds").getter(getter(CalculateRouteSummary::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(CalculateRouteSummary::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_B_BOX_FIELD,
            DATA_SOURCE_FIELD, DISTANCE_FIELD, DURATION_SECONDS_FIELD, DISTANCE_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Double> routeBBox;

    private final String dataSource;

    private final Double distance;

    private final Double durationSeconds;

    private final String distanceUnit;

    private CalculateRouteSummary(BuilderImpl builder) {
        this.routeBBox = builder.routeBBox;
        this.dataSource = builder.dataSource;
        this.distance = builder.distance;
        this.durationSeconds = builder.durationSeconds;
        this.distanceUnit = builder.distanceUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteBBox property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRouteBBox() {
        return routeBBox != null && !(routeBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For
     * example, <code>[min x, min y, max x, max y]</code>.
     * </p>
     * <p>
     * The first 2 <code>bbox</code> parameters describe the lower southwest corner:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
     * </p>
     * </li>
     * <li>
     * <p>
     * The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The next 2 <code>bbox</code> parameters describe the upper northeast corner:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
     * </p>
     * </li>
     * <li>
     * <p>
     * The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteBBox} method.
     * </p>
     * 
     * @return Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map.
     *         For example, <code>[min x, min y, max x, max y]</code>.</p>
     *         <p>
     *         The first 2 <code>bbox</code> parameters describe the lower southwest corner:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The next 2 <code>bbox</code> parameters describe the upper northeast corner:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
     *         </p>
     *         </li>
     */
    public final List<Double> routeBBox() {
        return routeBBox;
    }

    /**
     * <p>
     * The data provider of traffic and road network data used to calculate the route. Indicates one of the available
     * providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Esri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Grab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Here</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about data providers, see <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers</a>.
     * </p>
     * 
     * @return The data provider of traffic and road network data used to calculate the route. Indicates one of the
     *         available providers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Esri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Grab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Here</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about data providers, see <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The total distance covered by the route. The sum of the distance travelled between every stop on the route.
     * </p>
     * <note>
     * <p>
     * If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the
     * route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.
     * </p>
     * </note>
     * 
     * @return The total distance covered by the route. The sum of the distance travelled between every stop on the
     *         route.</p> <note>
     *         <p>
     *         If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If
     *         the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.
     *         </p>
     */
    public final Double distance() {
        return distance;
    }

    /**
     * <p>
     * The total travel time for the route measured in seconds. The sum of the travel time between every stop on the
     * route.
     * </p>
     * 
     * @return The total travel time for the route measured in seconds. The sum of the travel time between every stop on
     *         the route.
     */
    public final Double durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The unit of measurement for route distances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement for route distances.
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The unit of measurement for route distances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement for route distances.
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteBBox() ? routeBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteSummary)) {
            return false;
        }
        CalculateRouteSummary other = (CalculateRouteSummary) obj;
        return hasRouteBBox() == other.hasRouteBBox() && Objects.equals(routeBBox(), other.routeBBox())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(distance(), other.distance())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteSummary")
                .add("RouteBBox", routeBBox() == null ? null : "*** Sensitive Data Redacted ***").add("DataSource", dataSource())
                .add("Distance", distance()).add("DurationSeconds", durationSeconds())
                .add("DistanceUnit", distanceUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteBBox":
            return Optional.ofNullable(clazz.cast(routeBBox()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteBBox", ROUTE_B_BOX_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteSummary, T> g) {
        return obj -> g.apply((CalculateRouteSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculateRouteSummary> {
        /**
         * <p>
         * Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For
         * example, <code>[min x, min y, max x, max y]</code>.
         * </p>
         * <p>
         * The first 2 <code>bbox</code> parameters describe the lower southwest corner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The next 2 <code>bbox</code> parameters describe the upper northeast corner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
         * </p>
         * </li>
         * <li>
         * <p>
         * The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routeBBox
         *        Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a
         *        map. For example, <code>[min x, min y, max x, max y]</code>.</p>
         *        <p>
         *        The first 2 <code>bbox</code> parameters describe the lower southwest corner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The next 2 <code>bbox</code> parameters describe the upper northeast corner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeBBox(Collection<Double> routeBBox);

        /**
         * <p>
         * Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For
         * example, <code>[min x, min y, max x, max y]</code>.
         * </p>
         * <p>
         * The first 2 <code>bbox</code> parameters describe the lower southwest corner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The next 2 <code>bbox</code> parameters describe the upper northeast corner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
         * </p>
         * </li>
         * <li>
         * <p>
         * The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
         * </p>
         * </li>
         * </ul>
         * 
         * @param routeBBox
         *        Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a
         *        map. For example, <code>[min x, min y, max x, max y]</code>.</p>
         *        <p>
         *        The first 2 <code>bbox</code> parameters describe the lower southwest corner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The next 2 <code>bbox</code> parameters describe the upper northeast corner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeBBox(Double... routeBBox);

        /**
         * <p>
         * The data provider of traffic and road network data used to calculate the route. Indicates one of the
         * available providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Esri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Grab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Here</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about data providers, see <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location
         * Service data providers</a>.
         * </p>
         * 
         * @param dataSource
         *        The data provider of traffic and road network data used to calculate the route. Indicates one of the
         *        available providers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Esri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Grab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Here</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about data providers, see <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The total distance covered by the route. The sum of the distance travelled between every stop on the route.
         * </p>
         * <note>
         * <p>
         * If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the
         * route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.
         * </p>
         * </note>
         * 
         * @param distance
         *        The total distance covered by the route. The sum of the distance travelled between every stop on the
         *        route.</p> <note>
         *        <p>
         *        If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km.
         *        If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Double distance);

        /**
         * <p>
         * The total travel time for the route measured in seconds. The sum of the travel time between every stop on the
         * route.
         * </p>
         * 
         * @param durationSeconds
         *        The total travel time for the route measured in seconds. The sum of the travel time between every stop
         *        on the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Double durationSeconds);

        /**
         * <p>
         * The unit of measurement for route distances.
         * </p>
         * 
         * @param distanceUnit
         *        The unit of measurement for route distances.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The unit of measurement for route distances.
         * </p>
         * 
         * @param distanceUnit
         *        The unit of measurement for route distances.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> routeBBox = DefaultSdkAutoConstructList.getInstance();

        private String dataSource;

        private Double distance;

        private Double durationSeconds;

        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteSummary model) {
            routeBBox(model.routeBBox);
            dataSource(model.dataSource);
            distance(model.distance);
            durationSeconds(model.durationSeconds);
            distanceUnit(model.distanceUnit);
        }

        public final Collection<Double> getRouteBBox() {
            if (routeBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return routeBBox;
        }

        public final void setRouteBBox(Collection<Double> routeBBox) {
            this.routeBBox = BoundingBoxCopier.copy(routeBBox);
        }

        @Override
        public final Builder routeBBox(Collection<Double> routeBBox) {
            this.routeBBox = BoundingBoxCopier.copy(routeBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeBBox(Double... routeBBox) {
            routeBBox(Arrays.asList(routeBBox));
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Double getDistance() {
            return distance;
        }

        public final void setDistance(Double distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public final Double getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Double durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        @Override
        public CalculateRouteSummary build() {
            return new CalculateRouteSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
