/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyResponse extends LocationResponse implements
        ToCopyableBuilder<CreateKeyResponse.Builder, CreateKeyResponse> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(CreateKeyResponse::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(CreateKeyResponse::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(CreateKeyResponse::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(CreateKeyResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, KEY_ARN_FIELD,
            KEY_NAME_FIELD, CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String key;

    private final String keyArn;

    private final String keyName;

    private final Instant createTime;

    private CreateKeyResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.keyArn = builder.keyArn;
        this.keyName = builder.keyName;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The key value/string of an API key. This value is used when making API calls to authorize the call. For example,
     * see <a href="https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html">GetMapGlyphs</a>.
     * </p>
     * 
     * @return The key value/string of an API key. This value is used when making API calls to authorize the call. For
     *         example, see <a
     *         href="https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html">GetMapGlyphs</a>.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all
     * Amazon Web Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:key/ExampleKey</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across
     *         all Amazon Web Services.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:key/ExampleKey</code>
     *         </p>
     *         </li>
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The name of the API key resource.
     * </p>
     * 
     * @return The name of the API key resource.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The timestamp for when the API key resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the API key resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyResponse)) {
            return false;
        }
        CreateKeyResponse other = (CreateKeyResponse) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(keyArn(), other.keyArn())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeyResponse").add("Key", key() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KeyArn", keyArn()).add("KeyName", keyName()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyResponse, T> g) {
        return obj -> g.apply((CreateKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeyResponse> {
        /**
         * <p>
         * The key value/string of an API key. This value is used when making API calls to authorize the call. For
         * example, see <a
         * href="https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html">GetMapGlyphs</a>.
         * </p>
         * 
         * @param key
         *        The key value/string of an API key. This value is used when making API calls to authorize the call.
         *        For example, see <a
         *        href="https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html"
         *        >GetMapGlyphs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all
         * Amazon Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:key/ExampleKey</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyArn
         *        The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource
         *        across all Amazon Web Services.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example: <code>arn:aws:geo:region:account-id:key/ExampleKey</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The name of the API key resource.
         * </p>
         * 
         * @param keyName
         *        The name of the API key resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The timestamp for when the API key resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the API key resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String key;

        private String keyArn;

        private String keyName;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyResponse model) {
            super(model);
            key(model.key);
            keyArn(model.keyArn);
            keyName(model.keyName);
            createTime(model.createTime);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateKeyResponse build() {
            return new CreateKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
