/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrackerResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, UpdateTrackerResponse> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(UpdateTrackerResponse.getter(UpdateTrackerResponse::trackerName)).setter(UpdateTrackerResponse.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerName").build()}).build();
    private static final SdkField<String> TRACKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerArn").getter(UpdateTrackerResponse.getter(UpdateTrackerResponse::trackerArn)).setter(UpdateTrackerResponse.setter(Builder::trackerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackerArn").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(UpdateTrackerResponse.getter(UpdateTrackerResponse::updateTime)).setter(UpdateTrackerResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD, TRACKER_ARN_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTrackerResponse.memberNameToFieldInitializer();
    private final String trackerName;
    private final String trackerArn;
    private final Instant updateTime;

    private UpdateTrackerResponse(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.trackerArn = builder.trackerArn;
        this.updateTime = builder.updateTime;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final String trackerArn() {
        return this.trackerArn;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrackerResponse)) {
            return false;
        }
        UpdateTrackerResponse other = (UpdateTrackerResponse)((Object)obj);
        return Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.trackerArn(), other.trackerArn()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrackerResponse").add("TrackerName", (Object)this.trackerName()).add("TrackerArn", (Object)this.trackerArn()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "TrackerArn": {
                return Optional.ofNullable(clazz.cast(this.trackerArn()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("TrackerArn", TRACKER_ARN_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrackerResponse, T> g) {
        return obj -> g.apply((UpdateTrackerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String trackerName;
        private String trackerArn;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrackerResponse model) {
            super(model);
            this.trackerName(model.trackerName);
            this.trackerArn(model.trackerArn);
            this.updateTime(model.updateTime);
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getTrackerArn() {
            return this.trackerArn;
        }

        public final void setTrackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
        }

        @Override
        public final Builder trackerArn(String trackerArn) {
            this.trackerArn = trackerArn;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateTrackerResponse build() {
            return new UpdateTrackerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrackerResponse> {
        public Builder trackerName(String var1);

        public Builder trackerArn(String var1);

        public Builder updateTime(Instant var1);
    }
}

