/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForPositionRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, SearchPlaceIndexForPositionRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(SearchPlaceIndexForPositionRequest.getter(SearchPlaceIndexForPositionRequest::indexName)).setter(SearchPlaceIndexForPositionRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IndexName").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(SearchPlaceIndexForPositionRequest.getter(SearchPlaceIndexForPositionRequest::position)).setter(SearchPlaceIndexForPositionRequest.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPlaceIndexForPositionRequest.getter(SearchPlaceIndexForPositionRequest::maxResults)).setter(SearchPlaceIndexForPositionRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchPlaceIndexForPositionRequest.getter(SearchPlaceIndexForPositionRequest::language)).setter(SearchPlaceIndexForPositionRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(SearchPlaceIndexForPositionRequest.getter(SearchPlaceIndexForPositionRequest::key)).setter(SearchPlaceIndexForPositionRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, POSITION_FIELD, MAX_RESULTS_FIELD, LANGUAGE_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPlaceIndexForPositionRequest.memberNameToFieldInitializer();
    private final String indexName;
    private final List<Double> position;
    private final Integer maxResults;
    private final String language;
    private final String key;

    private SearchPlaceIndexForPositionRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.position = builder.position;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.key = builder.key;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String language() {
        return this.language;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionRequest)) {
            return false;
        }
        SearchPlaceIndexForPositionRequest other = (SearchPlaceIndexForPositionRequest)((Object)obj);
        return Objects.equals(this.indexName(), other.indexName()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForPositionRequest").add("IndexName", (Object)this.indexName()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("Language", (Object)this.language()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionRequest, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String indexName;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String language;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionRequest model) {
            super(model);
            this.indexName(model.indexName);
            this.position(model.position);
            this.maxResults(model.maxResults);
            this.language(model.language);
            this.key(model.key);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionRequest build() {
            return new SearchPlaceIndexForPositionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForPositionRequest> {
        public Builder indexName(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder maxResults(Integer var1);

        public Builder language(String var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

