/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.SearchForPositionResult;
import software.amazon.awssdk.services.location.model.SearchForPositionResultListCopier;
import software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForPositionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, SearchPlaceIndexForPositionResponse> {
    private static final SdkField<SearchPlaceIndexForPositionSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(SearchPlaceIndexForPositionResponse.getter(SearchPlaceIndexForPositionResponse::summary)).setter(SearchPlaceIndexForPositionResponse.setter(Builder::summary)).constructor(SearchPlaceIndexForPositionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<List<SearchForPositionResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(SearchPlaceIndexForPositionResponse.getter(SearchPlaceIndexForPositionResponse::results)).setter(SearchPlaceIndexForPositionResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchForPositionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPlaceIndexForPositionResponse.memberNameToFieldInitializer();
    private final SearchPlaceIndexForPositionSummary summary;
    private final List<SearchForPositionResult> results;

    private SearchPlaceIndexForPositionResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.results = builder.results;
    }

    public final SearchPlaceIndexForPositionSummary summary() {
        return this.summary;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<SearchForPositionResult> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionResponse)) {
            return false;
        }
        SearchPlaceIndexForPositionResponse other = (SearchPlaceIndexForPositionResponse)((Object)obj);
        return Objects.equals(this.summary(), other.summary()) && this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForPositionResponse").add("Summary", (Object)this.summary()).add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Summary", SUMMARY_FIELD);
        map.put("Results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private SearchPlaceIndexForPositionSummary summary;
        private List<SearchForPositionResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionResponse model) {
            super(model);
            this.summary(model.summary);
            this.results(model.results);
        }

        public final SearchPlaceIndexForPositionSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(SearchPlaceIndexForPositionSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForPositionSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<SearchForPositionResult.Builder> getResults() {
            List<SearchForPositionResult.Builder> result = SearchForPositionResultListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<SearchForPositionResult.BuilderImpl> results) {
            this.results = SearchForPositionResultListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<SearchForPositionResult> results) {
            this.results = SearchForPositionResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForPositionResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForPositionResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (SearchForPositionResult)((SearchForPositionResult.Builder)SearchForPositionResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchPlaceIndexForPositionResponse build() {
            return new SearchPlaceIndexForPositionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForPositionResponse> {
        public Builder summary(SearchPlaceIndexForPositionSummary var1);

        default public Builder summary(Consumer<SearchPlaceIndexForPositionSummary.Builder> summary) {
            return this.summary((SearchPlaceIndexForPositionSummary)((SearchPlaceIndexForPositionSummary.Builder)SearchPlaceIndexForPositionSummary.builder().applyMutation(summary)).build());
        }

        public Builder results(Collection<SearchForPositionResult> var1);

        public Builder results(SearchForPositionResult ... var1);

        public Builder results(Consumer<SearchForPositionResult.Builder> ... var1);
    }
}

