/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDevicePositionResponse extends LocationResponse implements
        ToCopyableBuilder<BatchGetDevicePositionResponse.Builder, BatchGetDevicePositionResponse> {
    private static final SdkField<List<BatchGetDevicePositionError>> ERRORS_FIELD = SdkField
            .<List<BatchGetDevicePositionError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetDevicePositionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetDevicePositionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetDevicePositionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DevicePosition>> DEVICE_POSITIONS_FIELD = SdkField
            .<List<DevicePosition>> builder(MarshallingType.LIST)
            .memberName("DevicePositions")
            .getter(getter(BatchGetDevicePositionResponse::devicePositions))
            .setter(setter(Builder::devicePositions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePositions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevicePosition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevicePosition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            DEVICE_POSITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchGetDevicePositionError> errors;

    private final List<DevicePosition> devicePositions;

    private BatchGetDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.devicePositions = builder.devicePositions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains error details for each device that failed to send its position to the tracker resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Contains error details for each device that failed to send its position to the tracker resource.
     */
    public final List<BatchGetDevicePositionError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the DevicePositions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDevicePositions() {
        return devicePositions != null && !(devicePositions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains device position details such as the device ID, position, and timestamps for when the position was
     * received and sampled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevicePositions} method.
     * </p>
     * 
     * @return Contains device position details such as the device ID, position, and timestamps for when the position
     *         was received and sampled.
     */
    public final List<DevicePosition> devicePositions() {
        return devicePositions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDevicePositions() ? devicePositions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevicePositionResponse)) {
            return false;
        }
        BatchGetDevicePositionResponse other = (BatchGetDevicePositionResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasDevicePositions() == other.hasDevicePositions()
                && Objects.equals(devicePositions(), other.devicePositions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDevicePositionResponse").add("Errors", hasErrors() ? errors() : null)
                .add("DevicePositions", hasDevicePositions() ? devicePositions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "DevicePositions":
            return Optional.ofNullable(clazz.cast(devicePositions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Errors", ERRORS_FIELD);
        map.put("DevicePositions", DEVICE_POSITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevicePositionResponse, T> g) {
        return obj -> g.apply((BatchGetDevicePositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDevicePositionResponse> {
        /**
         * <p>
         * Contains error details for each device that failed to send its position to the tracker resource.
         * </p>
         * 
         * @param errors
         *        Contains error details for each device that failed to send its position to the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetDevicePositionError> errors);

        /**
         * <p>
         * Contains error details for each device that failed to send its position to the tracker resource.
         * </p>
         * 
         * @param errors
         *        Contains error details for each device that failed to send its position to the tracker resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetDevicePositionError... errors);

        /**
         * <p>
         * Contains error details for each device that failed to send its position to the tracker resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.BatchGetDevicePositionError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.location.model.BatchGetDevicePositionError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.BatchGetDevicePositionError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetDevicePositionError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.BatchGetDevicePositionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetDevicePositionError>)
         */
        Builder errors(Consumer<BatchGetDevicePositionError.Builder>... errors);

        /**
         * <p>
         * Contains device position details such as the device ID, position, and timestamps for when the position was
         * received and sampled.
         * </p>
         * 
         * @param devicePositions
         *        Contains device position details such as the device ID, position, and timestamps for when the position
         *        was received and sampled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePositions(Collection<DevicePosition> devicePositions);

        /**
         * <p>
         * Contains device position details such as the device ID, position, and timestamps for when the position was
         * received and sampled.
         * </p>
         * 
         * @param devicePositions
         *        Contains device position details such as the device ID, position, and timestamps for when the position
         *        was received and sampled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePositions(DevicePosition... devicePositions);

        /**
         * <p>
         * Contains device position details such as the device ID, position, and timestamps for when the position was
         * received and sampled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.DevicePosition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.location.model.DevicePosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.DevicePosition.Builder#build()} is called immediately
         * and its result is passed to {@link #devicePositions(List<DevicePosition>)}.
         * 
         * @param devicePositions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.DevicePosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePositions(java.util.Collection<DevicePosition>)
         */
        Builder devicePositions(Consumer<DevicePosition.Builder>... devicePositions);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<BatchGetDevicePositionError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<DevicePosition> devicePositions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevicePositionResponse model) {
            super(model);
            errors(model.errors);
            devicePositions(model.devicePositions);
        }

        public final List<BatchGetDevicePositionError.Builder> getErrors() {
            List<BatchGetDevicePositionError.Builder> result = BatchGetDevicePositionErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetDevicePositionError.BuilderImpl> errors) {
            this.errors = BatchGetDevicePositionErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetDevicePositionError> errors) {
            this.errors = BatchGetDevicePositionErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetDevicePositionError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetDevicePositionError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetDevicePositionError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DevicePosition.Builder> getDevicePositions() {
            List<DevicePosition.Builder> result = DevicePositionListCopier.copyToBuilder(this.devicePositions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevicePositions(Collection<DevicePosition.BuilderImpl> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copyFromBuilder(devicePositions);
        }

        @Override
        public final Builder devicePositions(Collection<DevicePosition> devicePositions) {
            this.devicePositions = DevicePositionListCopier.copy(devicePositions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(DevicePosition... devicePositions) {
            devicePositions(Arrays.asList(devicePositions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePositions(Consumer<DevicePosition.Builder>... devicePositions) {
            devicePositions(Stream.of(devicePositions).map(c -> DevicePosition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetDevicePositionResponse build() {
            return new BatchGetDevicePositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
