/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains error details for each geofence that failed to be stored in a given geofence collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutGeofenceError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPutGeofenceError.Builder, BatchPutGeofenceError> {
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeofenceId").getter(getter(BatchPutGeofenceError::geofenceId)).setter(setter(Builder::geofenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()).build();

    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(BatchPutGeofenceError::error)).setter(setter(Builder::error))
            .constructor(BatchItemError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GEOFENCE_ID_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String geofenceId;

    private final BatchItemError error;

    private BatchPutGeofenceError(BuilderImpl builder) {
        this.geofenceId = builder.geofenceId;
        this.error = builder.error;
    }

    /**
     * <p>
     * The geofence associated with the error message.
     * </p>
     * 
     * @return The geofence associated with the error message.
     */
    public final String geofenceId() {
        return geofenceId;
    }

    /**
     * <p>
     * Contains details associated to the batch error.
     * </p>
     * 
     * @return Contains details associated to the batch error.
     */
    public final BatchItemError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geofenceId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutGeofenceError)) {
            return false;
        }
        BatchPutGeofenceError other = (BatchPutGeofenceError) obj;
        return Objects.equals(geofenceId(), other.geofenceId()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutGeofenceError").add("GeofenceId", geofenceId()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeofenceId":
            return Optional.ofNullable(clazz.cast(geofenceId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeofenceId", GEOFENCE_ID_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutGeofenceError, T> g) {
        return obj -> g.apply((BatchPutGeofenceError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPutGeofenceError> {
        /**
         * <p>
         * The geofence associated with the error message.
         * </p>
         * 
         * @param geofenceId
         *        The geofence associated with the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceId(String geofenceId);

        /**
         * <p>
         * Contains details associated to the batch error.
         * </p>
         * 
         * @param error
         *        Contains details associated to the batch error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(BatchItemError error);

        /**
         * <p>
         * Contains details associated to the batch error.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchItemError.Builder} avoiding the need
         * to create one manually via {@link BatchItemError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchItemError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(BatchItemError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link BatchItemError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(BatchItemError)
         */
        default Builder error(Consumer<BatchItemError.Builder> error) {
            return error(BatchItemError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String geofenceId;

        private BatchItemError error;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutGeofenceError model) {
            geofenceId(model.geofenceId);
            error(model.error);
        }

        public final String getGeofenceId() {
            return geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final BatchItemError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        @Override
        public BatchPutGeofenceError build() {
            return new BatchPutGeofenceError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
