/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the calculated route matrix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRouteMatrixSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculateRouteMatrixSummary.Builder, CalculateRouteMatrixSummary> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(CalculateRouteMatrixSummary::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Integer> ROUTE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RouteCount").getter(getter(CalculateRouteMatrixSummary::routeCount)).setter(setter(Builder::routeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteCount").build()).build();

    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorCount").getter(getter(CalculateRouteMatrixSummary::errorCount)).setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(CalculateRouteMatrixSummary::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            ROUTE_COUNT_FIELD, ERROR_COUNT_FIELD, DISTANCE_UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSource;

    private final Integer routeCount;

    private final Integer errorCount;

    private final String distanceUnit;

    private CalculateRouteMatrixSummary(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.routeCount = builder.routeCount;
        this.errorCount = builder.errorCount;
        this.distanceUnit = builder.distanceUnit;
    }

    /**
     * <p>
     * The data provider of traffic and road network data used to calculate the routes. Indicates one of the available
     * providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Esri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Grab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Here</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about data providers, see <a
     * href="https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html">Amazon Location
     * Service data providers</a>.
     * </p>
     * 
     * @return The data provider of traffic and road network data used to calculate the routes. Indicates one of the
     *         available providers:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Esri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Grab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Here</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about data providers, see <a
     *         href="https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html">Amazon
     *         Location Service data providers</a>.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the
     * number of <code>DestinationPositions</code>.
     * </p>
     * 
     * @return The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied
     *         by the number of <code>DestinationPositions</code>.
     */
    public final Integer routeCount() {
        return routeCount;
    }

    /**
     * <p>
     * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
     * </p>
     * 
     * @return The count of error results in the route matrix. If this number is 0, all routes were calculated
     *         successfully.
     */
    public final Integer errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * The unit of measurement for route distances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement for route distances.
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The unit of measurement for route distances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The unit of measurement for route distances.
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(routeCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixSummary)) {
            return false;
        }
        CalculateRouteMatrixSummary other = (CalculateRouteMatrixSummary) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(routeCount(), other.routeCount())
                && Objects.equals(errorCount(), other.errorCount())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRouteMatrixSummary").add("DataSource", dataSource()).add("RouteCount", routeCount())
                .add("ErrorCount", errorCount()).add("DistanceUnit", distanceUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "RouteCount":
            return Optional.ofNullable(clazz.cast(routeCount()));
        case "ErrorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("RouteCount", ROUTE_COUNT_FIELD);
        map.put("ErrorCount", ERROR_COUNT_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixSummary, T> g) {
        return obj -> g.apply((CalculateRouteMatrixSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculateRouteMatrixSummary> {
        /**
         * <p>
         * The data provider of traffic and road network data used to calculate the routes. Indicates one of the
         * available providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Esri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Grab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Here</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about data providers, see <a
         * href="https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html">Amazon
         * Location Service data providers</a>.
         * </p>
         * 
         * @param dataSource
         *        The data provider of traffic and road network data used to calculate the routes. Indicates one of the
         *        available providers:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Esri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Grab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Here</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about data providers, see <a
         *        href="https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html">Amazon
         *        Location Service data providers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by
         * the number of <code>DestinationPositions</code>.
         * </p>
         * 
         * @param routeCount
         *        The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code>
         *        multiplied by the number of <code>DestinationPositions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeCount(Integer routeCount);

        /**
         * <p>
         * The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.
         * </p>
         * 
         * @param errorCount
         *        The count of error results in the route matrix. If this number is 0, all routes were calculated
         *        successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Integer errorCount);

        /**
         * <p>
         * The unit of measurement for route distances.
         * </p>
         * 
         * @param distanceUnit
         *        The unit of measurement for route distances.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The unit of measurement for route distances.
         * </p>
         * 
         * @param distanceUnit
         *        The unit of measurement for route distances.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);
    }

    static final class BuilderImpl implements Builder {
        private String dataSource;

        private Integer routeCount;

        private Integer errorCount;

        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixSummary model) {
            dataSource(model.dataSource);
            routeCount(model.routeCount);
            errorCount(model.errorCount);
            distanceUnit(model.distanceUnit);
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Integer getRouteCount() {
            return routeCount;
        }

        public final void setRouteCount(Integer routeCount) {
            this.routeCount = routeCount;
        }

        @Override
        public final Builder routeCount(Integer routeCount) {
            this.routeCount = routeCount;
            return this;
        }

        public final Integer getErrorCount() {
            return errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        @Override
        public CalculateRouteMatrixSummary build() {
            return new CalculateRouteMatrixSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
