/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlaceIndexResponse extends LocationResponse implements
        ToCopyableBuilder<CreatePlaceIndexResponse.Builder, CreatePlaceIndexResponse> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(CreatePlaceIndexResponse::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexArn").getter(getter(CreatePlaceIndexResponse::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(CreatePlaceIndexResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            INDEX_ARN_FIELD, CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String indexName;

    private final String indexArn;

    private final Instant createTime;

    private CreatePlaceIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The name for the place index resource.
     * </p>
     * 
     * @return The name for the place index resource.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web
     * Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web
     *         Services. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code>
     *         </p>
     *         </li>
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The timestamp for when the place index resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the place index resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlaceIndexResponse)) {
            return false;
        }
        CreatePlaceIndexResponse other = (CreatePlaceIndexResponse) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(indexArn(), other.indexArn())
                && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlaceIndexResponse").add("IndexName", indexName()).add("IndexArn", indexArn())
                .add("CreateTime", createTime() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "IndexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("IndexArn", INDEX_ARN_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePlaceIndexResponse, T> g) {
        return obj -> g.apply((CreatePlaceIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlaceIndexResponse> {
        /**
         * <p>
         * The name for the place index resource.
         * </p>
         * 
         * @param indexName
         *        The name for the place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon Web
         * Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexArn
         *        The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across Amazon
         *        Web Services. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The timestamp for when the place index resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the place index resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String indexName;

        private String indexArn;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlaceIndexResponse model) {
            super(model);
            indexName(model.indexName);
            indexArn(model.indexArn);
            createTime(model.createTime);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreatePlaceIndexResponse build() {
            return new CreatePlaceIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
