/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGeofenceCollectionResponse extends LocationResponse implements
        ToCopyableBuilder<DescribeGeofenceCollectionResponse.Builder, DescribeGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(DescribeGeofenceCollectionResponse::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionArn").getter(getter(DescribeGeofenceCollectionResponse::collectionArn))
            .setter(setter(Builder::collectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeGeofenceCollectionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(DescribeGeofenceCollectionResponse::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(DescribeGeofenceCollectionResponse::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeGeofenceCollectionResponse::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeGeofenceCollectionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(DescribeGeofenceCollectionResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(DescribeGeofenceCollectionResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> GEOFENCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeofenceCount").getter(getter(DescribeGeofenceCollectionResponse::geofenceCount))
            .setter(setter(Builder::geofenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            COLLECTION_ARN_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, KMS_KEY_ID_FIELD,
            TAGS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, GEOFENCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collectionName;

    private final String collectionArn;

    private final String description;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final String kmsKeyId;

    private final Map<String, String> tags;

    private final Instant createTime;

    private final Instant updateTime;

    private final Integer geofenceCount;

    private DescribeGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.collectionArn = builder.collectionArn;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.geofenceCount = builder.geofenceCount;
    }

    /**
     * <p>
     * The name of the geofence collection.
     * </p>
     * 
     * @return The name of the geofence collection.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource
     * across all Amazon Web Services.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a
     *         resource across all Amazon Web Services. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
     *         </p>
     *         </li>
     */
    public final String collectionArn() {
        return collectionArn;
    }

    /**
     * <p>
     * The optional description for the geofence collection.
     * </p>
     * 
     * @return The optional description for the geofence collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * No longer used. Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * No longer used. Always returns an empty string.
     * </p>
     * 
     * @return No longer used. Always returns an empty string.
     * @deprecated Deprecated. Unused.
     */
    @Deprecated
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * <p>
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon
     * Web Services KMS customer managed key</a> assigned to the Amazon Location resource
     * </p>
     * 
     * @return A key identifier for an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
     *         customer managed key</a> assigned to the Amazon Location resource
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Displays the key, value pairs of tags associated with this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Displays the key, value pairs of tags associated with this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp for when the geofence resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The timestamp for when the geofence resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The timestamp for when the geofence collection was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * </p>
     * 
     * @return The timestamp for when the geofence collection was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The number of geofences in the geofence collection.
     * </p>
     * 
     * @return The number of geofences in the geofence collection.
     */
    public final Integer geofenceCount() {
        return geofenceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(geofenceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGeofenceCollectionResponse)) {
            return false;
        }
        DescribeGeofenceCollectionResponse other = (DescribeGeofenceCollectionResponse) obj;
        return Objects.equals(collectionName(), other.collectionName()) && Objects.equals(collectionArn(), other.collectionArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(geofenceCount(), other.geofenceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGeofenceCollectionResponse").add("CollectionName", collectionName())
                .add("CollectionArn", collectionArn()).add("Description", description())
                .add("PricingPlan", pricingPlanAsString()).add("PricingPlanDataSource", pricingPlanDataSource())
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("CreateTime", createTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdateTime", updateTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GeofenceCount", geofenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "CollectionArn":
            return Optional.ofNullable(clazz.cast(collectionArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "GeofenceCount":
            return Optional.ofNullable(clazz.cast(geofenceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("CollectionArn", COLLECTION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PricingPlan", PRICING_PLAN_FIELD);
        map.put("PricingPlanDataSource", PRICING_PLAN_DATA_SOURCE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        map.put("GeofenceCount", GEOFENCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((DescribeGeofenceCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGeofenceCollectionResponse> {
        /**
         * <p>
         * The name of the geofence collection.
         * </p>
         * 
         * @param collectionName
         *        The name of the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource
         * across all Amazon Web Services.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param collectionArn
         *        The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a
         *        resource across all Amazon Web Services. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format example:
         *        <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);

        /**
         * <p>
         * The optional description for the geofence collection.
         * </p>
         * 
         * @param description
         *        The optional description for the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * No longer used. Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * No longer used. Always returns an empty string.
         * </p>
         * 
         * @param pricingPlanDataSource
         *        No longer used. Always returns an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Deprecated. Unused.
         */
        @Deprecated
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * A key identifier for an <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         * customer managed key</a> assigned to the Amazon Location resource
         * </p>
         * 
         * @param kmsKeyId
         *        A key identifier for an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">Amazon Web Services KMS
         *        customer managed key</a> assigned to the Amazon Location resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Displays the key, value pairs of tags associated with this resource.
         * </p>
         * 
         * @param tags
         *        Displays the key, value pairs of tags associated with this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp for when the geofence resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the geofence resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The timestamp for when the geofence collection was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the geofence collection was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The number of geofences in the geofence collection.
         * </p>
         * 
         * @param geofenceCount
         *        The number of geofences in the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceCount(Integer geofenceCount);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private String collectionName;

        private String collectionArn;

        private String description;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private String kmsKeyId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createTime;

        private Instant updateTime;

        private Integer geofenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGeofenceCollectionResponse model) {
            super(model);
            collectionName(model.collectionName);
            collectionArn(model.collectionArn);
            description(model.description);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            createTime(model.createTime);
            updateTime(model.updateTime);
            geofenceCount(model.geofenceCount);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Integer getGeofenceCount() {
            return geofenceCount;
        }

        public final void setGeofenceCount(Integer geofenceCount) {
            this.geofenceCount = geofenceCount;
        }

        @Override
        public final Builder geofenceCount(Integer geofenceCount) {
            this.geofenceCount = geofenceCount;
            return this;
        }

        @Override
        public DescribeGeofenceCollectionResponse build() {
            return new DescribeGeofenceCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
