/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMapSpritesRequest extends LocationRequest implements
        ToCopyableBuilder<GetMapSpritesRequest.Builder, GetMapSpritesRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(GetMapSpritesRequest::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(GetMapSpritesRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(GetMapSpritesRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD,
            FILE_NAME_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mapName;

    private final String fileName;

    private final String key;

    private GetMapSpritesRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.fileName = builder.fileName;
        this.key = builder.key;
    }

    /**
     * <p>
     * The map resource associated with the sprite ﬁle.
     * </p>
     * 
     * @return The map resource associated with the sprite ﬁle.
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sprites.png</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sprites@2x.png</code> for high pixel density displays
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the JSON document containing image offsets. Use the following ﬁle names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sprites.json</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sprites@2x.json</code> for high pixel density displays
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sprites.png</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sprites@2x.png</code> for high pixel density displays
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For the JSON document containing image offsets. Use the following ﬁle names:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sprites.json</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sprites@2x.json</code> for high pixel density displays
     *         </p>
     *         </li>
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The optional <a href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API
     * key</a> to authorize the request.
     * </p>
     * 
     * @return The optional <a
     *         href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API key</a> to
     *         authorize the request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapSpritesRequest)) {
            return false;
        }
        GetMapSpritesRequest other = (GetMapSpritesRequest) obj;
        return Objects.equals(mapName(), other.mapName()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMapSpritesRequest").add("MapName", mapName()).add("FileName", fileName())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMapSpritesRequest, T> g) {
        return obj -> g.apply((GetMapSpritesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMapSpritesRequest> {
        /**
         * <p>
         * The map resource associated with the sprite ﬁle.
         * </p>
         * 
         * @param mapName
         *        The map resource associated with the sprite ﬁle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sprites.png</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sprites@2x.png</code> for high pixel density displays
         * </p>
         * </li>
         * </ul>
         * <p>
         * For the JSON document containing image offsets. Use the following ﬁle names:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sprites.json</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sprites@2x.json</code> for high pixel density displays
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileName
         *        The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sprites.png</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sprites@2x.png</code> for high pixel density displays
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For the JSON document containing image offsets. Use the following ﬁle names:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sprites.json</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sprites@2x.json</code> for high pixel density displays
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The optional <a href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API
         * key</a> to authorize the request.
         * </p>
         * 
         * @param key
         *        The optional <a
         *        href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API key</a> to
         *        authorize the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String mapName;

        private String fileName;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapSpritesRequest model) {
            super(model);
            mapName(model.mapName);
            fileName(model.fileName);
            key(model.key);
        }

        public final String getMapName() {
            return mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapSpritesRequest build() {
            return new GetMapSpritesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
