/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the tracker resource details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicePositionsResponseEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListDevicePositionsResponseEntry.Builder, ListDevicePositionsResponseEntry> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(ListDevicePositionsResponseEntry::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SampleTime")
            .getter(getter(ListDevicePositionsResponseEntry::sampleTime))
            .setter(setter(Builder::sampleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(ListDevicePositionsResponseEntry::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PositionalAccuracy> ACCURACY_FIELD = SdkField
            .<PositionalAccuracy> builder(MarshallingType.SDK_POJO).memberName("Accuracy")
            .getter(getter(ListDevicePositionsResponseEntry::accuracy)).setter(setter(Builder::accuracy))
            .constructor(PositionalAccuracy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()).build();

    private static final SdkField<Map<String, String>> POSITION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PositionProperties")
            .getter(getter(ListDevicePositionsResponseEntry::positionProperties))
            .setter(setter(Builder::positionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            SAMPLE_TIME_FIELD, POSITION_FIELD, ACCURACY_FIELD, POSITION_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceId;

    private final Instant sampleTime;

    private final List<Double> position;

    private final PositionalAccuracy accuracy;

    private final Map<String, String> positionProperties;

    private ListDevicePositionsResponseEntry(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.position = builder.position;
        this.accuracy = builder.accuracy;
        this.positionProperties = builder.positionProperties;
    }

    /**
     * <p>
     * The ID of the device for this position.
     * </p>
     * 
     * @return The ID of the device for this position.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The timestamp at which the device position was determined. Uses <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp at which the device position was determined. Uses <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant sampleTime() {
        return sampleTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The last known device position. Empty if no positions currently stored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return The last known device position. Empty if no positions currently stored.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * The accuracy of the device position.
     * </p>
     * 
     * @return The accuracy of the device position.
     */
    public final PositionalAccuracy accuracy() {
        return accuracy;
    }

    /**
     * For responses, this returns true if the service returned a value for the PositionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPositionProperties() {
        return positionProperties != null && !(positionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties associated with the position.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPositionProperties} method.
     * </p>
     * 
     * @return The properties associated with the position.
     */
    public final Map<String, String> positionProperties() {
        return positionProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(hasPositionProperties() ? positionProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePositionsResponseEntry)) {
            return false;
        }
        ListDevicePositionsResponseEntry other = (ListDevicePositionsResponseEntry) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(sampleTime(), other.sampleTime())
                && hasPosition() == other.hasPosition() && Objects.equals(position(), other.position())
                && Objects.equals(accuracy(), other.accuracy()) && hasPositionProperties() == other.hasPositionProperties()
                && Objects.equals(positionProperties(), other.positionProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDevicePositionsResponseEntry").add("DeviceId", deviceId())
                .add("SampleTime", sampleTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").add("Accuracy", accuracy())
                .add("PositionProperties", positionProperties() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "SampleTime":
            return Optional.ofNullable(clazz.cast(sampleTime()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "Accuracy":
            return Optional.ofNullable(clazz.cast(accuracy()));
        case "PositionProperties":
            return Optional.ofNullable(clazz.cast(positionProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("SampleTime", SAMPLE_TIME_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("PositionProperties", POSITION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicePositionsResponseEntry, T> g) {
        return obj -> g.apply((ListDevicePositionsResponseEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListDevicePositionsResponseEntry> {
        /**
         * <p>
         * The ID of the device for this position.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device for this position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The timestamp at which the device position was determined. Uses <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param sampleTime
         *        The timestamp at which the device position was determined. Uses <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleTime(Instant sampleTime);

        /**
         * <p>
         * The last known device position. Empty if no positions currently stored.
         * </p>
         * 
         * @param position
         *        The last known device position. Empty if no positions currently stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * The last known device position. Empty if no positions currently stored.
         * </p>
         * 
         * @param position
         *        The last known device position. Empty if no positions currently stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * The accuracy of the device position.
         * </p>
         * 
         * @param accuracy
         *        The accuracy of the device position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accuracy(PositionalAccuracy accuracy);

        /**
         * <p>
         * The accuracy of the device position.
         * </p>
         * This is a convenience method that creates an instance of the {@link PositionalAccuracy.Builder} avoiding the
         * need to create one manually via {@link PositionalAccuracy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PositionalAccuracy.Builder#build()} is called immediately and its
         * result is passed to {@link #accuracy(PositionalAccuracy)}.
         * 
         * @param accuracy
         *        a consumer that will call methods on {@link PositionalAccuracy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accuracy(PositionalAccuracy)
         */
        default Builder accuracy(Consumer<PositionalAccuracy.Builder> accuracy) {
            return accuracy(PositionalAccuracy.builder().applyMutation(accuracy).build());
        }

        /**
         * <p>
         * The properties associated with the position.
         * </p>
         * 
         * @param positionProperties
         *        The properties associated with the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positionProperties(Map<String, String> positionProperties);
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private Instant sampleTime;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private PositionalAccuracy accuracy;

        private Map<String, String> positionProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePositionsResponseEntry model) {
            deviceId(model.deviceId);
            sampleTime(model.sampleTime);
            position(model.position);
            accuracy(model.accuracy);
            positionProperties(model.positionProperties);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final PositionalAccuracy.Builder getAccuracy() {
            return accuracy != null ? accuracy.toBuilder() : null;
        }

        public final void setAccuracy(PositionalAccuracy.BuilderImpl accuracy) {
            this.accuracy = accuracy != null ? accuracy.build() : null;
        }

        @Override
        public final Builder accuracy(PositionalAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final Map<String, String> getPositionProperties() {
            if (positionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return positionProperties;
        }

        public final void setPositionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PositionPropertyMapCopier.copy(positionProperties);
        }

        @Override
        public final Builder positionProperties(Map<String, String> positionProperties) {
            this.positionProperties = PositionPropertyMapCopier.copy(positionProperties);
            return this;
        }

        @Override
        public ListDevicePositionsResponseEntry build() {
            return new ListDevicePositionsResponseEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
