/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Long-Term Evolution (LTE) network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LteCellDetails implements SdkPojo, Serializable, ToCopyableBuilder<LteCellDetails.Builder, LteCellDetails> {
    private static final SdkField<Integer> CELL_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CellId").getter(getter(LteCellDetails::cellId)).setter(setter(Builder::cellId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellId").build()).build();

    private static final SdkField<Integer> MCC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mcc")
            .getter(getter(LteCellDetails::mcc)).setter(setter(Builder::mcc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()).build();

    private static final SdkField<Integer> MNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Mnc")
            .getter(getter(LteCellDetails::mnc)).setter(setter(Builder::mnc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()).build();

    private static final SdkField<LteLocalId> LOCAL_ID_FIELD = SdkField.<LteLocalId> builder(MarshallingType.SDK_POJO)
            .memberName("LocalId").getter(getter(LteCellDetails::localId)).setter(setter(Builder::localId))
            .constructor(LteLocalId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalId").build()).build();

    private static final SdkField<List<LteNetworkMeasurements>> NETWORK_MEASUREMENTS_FIELD = SdkField
            .<List<LteNetworkMeasurements>> builder(MarshallingType.LIST)
            .memberName("NetworkMeasurements")
            .getter(getter(LteCellDetails::networkMeasurements))
            .setter(setter(Builder::networkMeasurements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkMeasurements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LteNetworkMeasurements> builder(MarshallingType.SDK_POJO)
                                            .constructor(LteNetworkMeasurements::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMING_ADVANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimingAdvance").getter(getter(LteCellDetails::timingAdvance)).setter(setter(Builder::timingAdvance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingAdvance").build()).build();

    private static final SdkField<Boolean> NR_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NrCapable").getter(getter(LteCellDetails::nrCapable)).setter(setter(Builder::nrCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NrCapable").build()).build();

    private static final SdkField<Integer> RSRP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rsrp")
            .getter(getter(LteCellDetails::rsrp)).setter(setter(Builder::rsrp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()).build();

    private static final SdkField<Float> RSRQ_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Rsrq")
            .getter(getter(LteCellDetails::rsrq)).setter(setter(Builder::rsrq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()).build();

    private static final SdkField<Integer> TAC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Tac")
            .getter(getter(LteCellDetails::tac)).setter(setter(Builder::tac))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tac").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_ID_FIELD, MCC_FIELD,
            MNC_FIELD, LOCAL_ID_FIELD, NETWORK_MEASUREMENTS_FIELD, TIMING_ADVANCE_FIELD, NR_CAPABLE_FIELD, RSRP_FIELD,
            RSRQ_FIELD, TAC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer cellId;

    private final Integer mcc;

    private final Integer mnc;

    private final LteLocalId localId;

    private final List<LteNetworkMeasurements> networkMeasurements;

    private final Integer timingAdvance;

    private final Boolean nrCapable;

    private final Integer rsrp;

    private final Float rsrq;

    private final Integer tac;

    private LteCellDetails(BuilderImpl builder) {
        this.cellId = builder.cellId;
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.localId = builder.localId;
        this.networkMeasurements = builder.networkMeasurements;
        this.timingAdvance = builder.timingAdvance;
        this.nrCapable = builder.nrCapable;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
        this.tac = builder.tac;
    }

    /**
     * <p>
     * The E-UTRAN Cell Identifier (ECI).
     * </p>
     * 
     * @return The E-UTRAN Cell Identifier (ECI).
     */
    public final Integer cellId() {
        return cellId;
    }

    /**
     * <p>
     * The Mobile Country Code (MCC).
     * </p>
     * 
     * @return The Mobile Country Code (MCC).
     */
    public final Integer mcc() {
        return mcc;
    }

    /**
     * <p>
     * The Mobile Network Code (MNC)
     * </p>
     * 
     * @return The Mobile Network Code (MNC)
     */
    public final Integer mnc() {
        return mnc;
    }

    /**
     * <p>
     * The LTE local identification information (local ID).
     * </p>
     * 
     * @return The LTE local identification information (local ID).
     */
    public final LteLocalId localId() {
        return localId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkMeasurements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkMeasurements() {
        return networkMeasurements != null && !(networkMeasurements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network measurements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkMeasurements} method.
     * </p>
     * 
     * @return The network measurements.
     */
    public final List<LteNetworkMeasurements> networkMeasurements() {
        return networkMeasurements;
    }

    /**
     * <p>
     * Timing Advance (TA).
     * </p>
     * 
     * @return Timing Advance (TA).
     */
    public final Integer timingAdvance() {
        return timingAdvance;
    }

    /**
     * <p>
     * Indicates whether the LTE object is capable of supporting NR (new radio).
     * </p>
     * 
     * @return Indicates whether the LTE object is capable of supporting NR (new radio).
     */
    public final Boolean nrCapable() {
        return nrCapable;
    }

    /**
     * <p>
     * Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
     * </p>
     * 
     * @return Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
     */
    public final Integer rsrp() {
        return rsrp;
    }

    /**
     * <p>
     * Signal quality of the reference Signal received, measured in decibels (dB).
     * </p>
     * 
     * @return Signal quality of the reference Signal received, measured in decibels (dB).
     */
    public final Float rsrq() {
        return rsrq;
    }

    /**
     * <p>
     * LTE Tracking Area Code (TAC).
     * </p>
     * 
     * @return LTE Tracking Area Code (TAC).
     */
    public final Integer tac() {
        return tac;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cellId());
        hashCode = 31 * hashCode + Objects.hashCode(mcc());
        hashCode = 31 * hashCode + Objects.hashCode(mnc());
        hashCode = 31 * hashCode + Objects.hashCode(localId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkMeasurements() ? networkMeasurements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(nrCapable());
        hashCode = 31 * hashCode + Objects.hashCode(rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(rsrq());
        hashCode = 31 * hashCode + Objects.hashCode(tac());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteCellDetails)) {
            return false;
        }
        LteCellDetails other = (LteCellDetails) obj;
        return Objects.equals(cellId(), other.cellId()) && Objects.equals(mcc(), other.mcc())
                && Objects.equals(mnc(), other.mnc()) && Objects.equals(localId(), other.localId())
                && hasNetworkMeasurements() == other.hasNetworkMeasurements()
                && Objects.equals(networkMeasurements(), other.networkMeasurements())
                && Objects.equals(timingAdvance(), other.timingAdvance()) && Objects.equals(nrCapable(), other.nrCapable())
                && Objects.equals(rsrp(), other.rsrp()) && Objects.equals(rsrq(), other.rsrq())
                && Objects.equals(tac(), other.tac());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LteCellDetails").add("CellId", cellId()).add("Mcc", mcc()).add("Mnc", mnc())
                .add("LocalId", localId()).add("NetworkMeasurements", hasNetworkMeasurements() ? networkMeasurements() : null)
                .add("TimingAdvance", timingAdvance()).add("NrCapable", nrCapable()).add("Rsrp", rsrp()).add("Rsrq", rsrq())
                .add("Tac", tac()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CellId":
            return Optional.ofNullable(clazz.cast(cellId()));
        case "Mcc":
            return Optional.ofNullable(clazz.cast(mcc()));
        case "Mnc":
            return Optional.ofNullable(clazz.cast(mnc()));
        case "LocalId":
            return Optional.ofNullable(clazz.cast(localId()));
        case "NetworkMeasurements":
            return Optional.ofNullable(clazz.cast(networkMeasurements()));
        case "TimingAdvance":
            return Optional.ofNullable(clazz.cast(timingAdvance()));
        case "NrCapable":
            return Optional.ofNullable(clazz.cast(nrCapable()));
        case "Rsrp":
            return Optional.ofNullable(clazz.cast(rsrp()));
        case "Rsrq":
            return Optional.ofNullable(clazz.cast(rsrq()));
        case "Tac":
            return Optional.ofNullable(clazz.cast(tac()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CellId", CELL_ID_FIELD);
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("LocalId", LOCAL_ID_FIELD);
        map.put("NetworkMeasurements", NETWORK_MEASUREMENTS_FIELD);
        map.put("TimingAdvance", TIMING_ADVANCE_FIELD);
        map.put("NrCapable", NR_CAPABLE_FIELD);
        map.put("Rsrp", RSRP_FIELD);
        map.put("Rsrq", RSRQ_FIELD);
        map.put("Tac", TAC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteCellDetails, T> g) {
        return obj -> g.apply((LteCellDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LteCellDetails> {
        /**
         * <p>
         * The E-UTRAN Cell Identifier (ECI).
         * </p>
         * 
         * @param cellId
         *        The E-UTRAN Cell Identifier (ECI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellId(Integer cellId);

        /**
         * <p>
         * The Mobile Country Code (MCC).
         * </p>
         * 
         * @param mcc
         *        The Mobile Country Code (MCC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcc(Integer mcc);

        /**
         * <p>
         * The Mobile Network Code (MNC)
         * </p>
         * 
         * @param mnc
         *        The Mobile Network Code (MNC)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mnc(Integer mnc);

        /**
         * <p>
         * The LTE local identification information (local ID).
         * </p>
         * 
         * @param localId
         *        The LTE local identification information (local ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localId(LteLocalId localId);

        /**
         * <p>
         * The LTE local identification information (local ID).
         * </p>
         * This is a convenience method that creates an instance of the {@link LteLocalId.Builder} avoiding the need to
         * create one manually via {@link LteLocalId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LteLocalId.Builder#build()} is called immediately and its result
         * is passed to {@link #localId(LteLocalId)}.
         * 
         * @param localId
         *        a consumer that will call methods on {@link LteLocalId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localId(LteLocalId)
         */
        default Builder localId(Consumer<LteLocalId.Builder> localId) {
            return localId(LteLocalId.builder().applyMutation(localId).build());
        }

        /**
         * <p>
         * The network measurements.
         * </p>
         * 
         * @param networkMeasurements
         *        The network measurements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkMeasurements(Collection<LteNetworkMeasurements> networkMeasurements);

        /**
         * <p>
         * The network measurements.
         * </p>
         * 
         * @param networkMeasurements
         *        The network measurements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkMeasurements(LteNetworkMeasurements... networkMeasurements);

        /**
         * <p>
         * The network measurements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.LteNetworkMeasurements.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.location.model.LteNetworkMeasurements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.LteNetworkMeasurements.Builder#build()} is called
         * immediately and its result is passed to {@link #networkMeasurements(List<LteNetworkMeasurements>)}.
         * 
         * @param networkMeasurements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.LteNetworkMeasurements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkMeasurements(java.util.Collection<LteNetworkMeasurements>)
         */
        Builder networkMeasurements(Consumer<LteNetworkMeasurements.Builder>... networkMeasurements);

        /**
         * <p>
         * Timing Advance (TA).
         * </p>
         * 
         * @param timingAdvance
         *        Timing Advance (TA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timingAdvance(Integer timingAdvance);

        /**
         * <p>
         * Indicates whether the LTE object is capable of supporting NR (new radio).
         * </p>
         * 
         * @param nrCapable
         *        Indicates whether the LTE object is capable of supporting NR (new radio).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nrCapable(Boolean nrCapable);

        /**
         * <p>
         * Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
         * </p>
         * 
         * @param rsrp
         *        Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrp(Integer rsrp);

        /**
         * <p>
         * Signal quality of the reference Signal received, measured in decibels (dB).
         * </p>
         * 
         * @param rsrq
         *        Signal quality of the reference Signal received, measured in decibels (dB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rsrq(Float rsrq);

        /**
         * <p>
         * LTE Tracking Area Code (TAC).
         * </p>
         * 
         * @param tac
         *        LTE Tracking Area Code (TAC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tac(Integer tac);
    }

    static final class BuilderImpl implements Builder {
        private Integer cellId;

        private Integer mcc;

        private Integer mnc;

        private LteLocalId localId;

        private List<LteNetworkMeasurements> networkMeasurements = DefaultSdkAutoConstructList.getInstance();

        private Integer timingAdvance;

        private Boolean nrCapable;

        private Integer rsrp;

        private Float rsrq;

        private Integer tac;

        private BuilderImpl() {
        }

        private BuilderImpl(LteCellDetails model) {
            cellId(model.cellId);
            mcc(model.mcc);
            mnc(model.mnc);
            localId(model.localId);
            networkMeasurements(model.networkMeasurements);
            timingAdvance(model.timingAdvance);
            nrCapable(model.nrCapable);
            rsrp(model.rsrp);
            rsrq(model.rsrq);
            tac(model.tac);
        }

        public final Integer getCellId() {
            return cellId;
        }

        public final void setCellId(Integer cellId) {
            this.cellId = cellId;
        }

        @Override
        public final Builder cellId(Integer cellId) {
            this.cellId = cellId;
            return this;
        }

        public final Integer getMcc() {
            return mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final LteLocalId.Builder getLocalId() {
            return localId != null ? localId.toBuilder() : null;
        }

        public final void setLocalId(LteLocalId.BuilderImpl localId) {
            this.localId = localId != null ? localId.build() : null;
        }

        @Override
        public final Builder localId(LteLocalId localId) {
            this.localId = localId;
            return this;
        }

        public final List<LteNetworkMeasurements.Builder> getNetworkMeasurements() {
            List<LteNetworkMeasurements.Builder> result = LteCellDetailsNetworkMeasurementsListCopier
                    .copyToBuilder(this.networkMeasurements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkMeasurements(Collection<LteNetworkMeasurements.BuilderImpl> networkMeasurements) {
            this.networkMeasurements = LteCellDetailsNetworkMeasurementsListCopier.copyFromBuilder(networkMeasurements);
        }

        @Override
        public final Builder networkMeasurements(Collection<LteNetworkMeasurements> networkMeasurements) {
            this.networkMeasurements = LteCellDetailsNetworkMeasurementsListCopier.copy(networkMeasurements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkMeasurements(LteNetworkMeasurements... networkMeasurements) {
            networkMeasurements(Arrays.asList(networkMeasurements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkMeasurements(Consumer<LteNetworkMeasurements.Builder>... networkMeasurements) {
            networkMeasurements(Stream.of(networkMeasurements)
                    .map(c -> LteNetworkMeasurements.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTimingAdvance() {
            return timingAdvance;
        }

        public final void setTimingAdvance(Integer timingAdvance) {
            this.timingAdvance = timingAdvance;
        }

        @Override
        public final Builder timingAdvance(Integer timingAdvance) {
            this.timingAdvance = timingAdvance;
            return this;
        }

        public final Boolean getNrCapable() {
            return nrCapable;
        }

        public final void setNrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
        }

        @Override
        public final Builder nrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
            return this;
        }

        public final Integer getRsrp() {
            return rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        public final Integer getTac() {
            return tac;
        }

        public final void setTac(Integer tac) {
            this.tac = tac;
        }

        @Override
        public final Builder tac(Integer tac) {
            this.tac = tac;
            return this;
        }

        @Override
        public LteCellDetails build() {
            return new LteCellDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
