/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RouteMatrixCopier {
    static List<List<RouteMatrixEntry>> copy(Collection<? extends Collection<? extends RouteMatrixEntry>> routeMatrixParam) {
        List<List<RouteMatrixEntry>> list;
        if (routeMatrixParam == null || routeMatrixParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<RouteMatrixEntry>> modifiableList = new ArrayList<>(routeMatrixParam.size());
            routeMatrixParam.forEach(entry -> {
                List<RouteMatrixEntry> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<RouteMatrixEntry> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        modifiableList1.add(entry1);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<RouteMatrixEntry>> copyFromBuilder(
            Collection<? extends Collection<? extends RouteMatrixEntry.Builder>> routeMatrixParam) {
        List<List<RouteMatrixEntry>> list;
        if (routeMatrixParam == null || routeMatrixParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<RouteMatrixEntry>> modifiableList = new ArrayList<>(routeMatrixParam.size());
            routeMatrixParam.forEach(entry -> {
                List<RouteMatrixEntry> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<RouteMatrixEntry> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        RouteMatrixEntry member = entry1 == null ? null : entry1.build();
                        modifiableList1.add(member);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<List<RouteMatrixEntry.Builder>> copyToBuilder(
            Collection<? extends Collection<? extends RouteMatrixEntry>> routeMatrixParam) {
        List<List<RouteMatrixEntry.Builder>> list;
        if (routeMatrixParam == null || routeMatrixParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<RouteMatrixEntry.Builder>> modifiableList = new ArrayList<>(routeMatrixParam.size());
            routeMatrixParam.forEach(entry -> {
                List<RouteMatrixEntry.Builder> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<RouteMatrixEntry.Builder> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        RouteMatrixEntry.Builder member = entry1 == null ? null : entry1.toBuilder();
                        modifiableList1.add(member);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
