/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Unique identifying information for an Android app. Consists of a package name and a 20 byte SHA-1 certificate
 * fingerprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AndroidApp implements SdkPojo, Serializable, ToCopyableBuilder<AndroidApp.Builder, AndroidApp> {
    private static final SdkField<String> PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Package")
            .getter(getter(AndroidApp::packageValue)).setter(setter(Builder::packageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Package").build()).build();

    private static final SdkField<String> CERTIFICATE_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateFingerprint").getter(getter(AndroidApp::certificateFingerprint))
            .setter(setter(Builder::certificateFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateFingerprint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_FIELD,
            CERTIFICATE_FINGERPRINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String packageValue;

    private final String certificateFingerprint;

    private AndroidApp(BuilderImpl builder) {
        this.packageValue = builder.packageValue;
        this.certificateFingerprint = builder.certificateFingerprint;
    }

    /**
     * <p>
     * Unique package name for an Android app.
     * </p>
     * 
     * @return Unique package name for an Android app.
     */
    public final String packageValue() {
        return packageValue;
    }

    /**
     * <p>
     * 20 byte SHA-1 certificate fingerprint associated with the Android app signing certificate.
     * </p>
     * 
     * @return 20 byte SHA-1 certificate fingerprint associated with the Android app signing certificate.
     */
    public final String certificateFingerprint() {
        return certificateFingerprint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(certificateFingerprint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AndroidApp)) {
            return false;
        }
        AndroidApp other = (AndroidApp) obj;
        return Objects.equals(packageValue(), other.packageValue())
                && Objects.equals(certificateFingerprint(), other.certificateFingerprint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AndroidApp").add("Package", packageValue())
                .add("CertificateFingerprint", certificateFingerprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Package":
            return Optional.ofNullable(clazz.cast(packageValue()));
        case "CertificateFingerprint":
            return Optional.ofNullable(clazz.cast(certificateFingerprint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Package", PACKAGE_FIELD);
        map.put("CertificateFingerprint", CERTIFICATE_FINGERPRINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AndroidApp, T> g) {
        return obj -> g.apply((AndroidApp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AndroidApp> {
        /**
         * <p>
         * Unique package name for an Android app.
         * </p>
         * 
         * @param packageValue
         *        Unique package name for an Android app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageValue(String packageValue);

        /**
         * <p>
         * 20 byte SHA-1 certificate fingerprint associated with the Android app signing certificate.
         * </p>
         * 
         * @param certificateFingerprint
         *        20 byte SHA-1 certificate fingerprint associated with the Android app signing certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateFingerprint(String certificateFingerprint);
    }

    static final class BuilderImpl implements Builder {
        private String packageValue;

        private String certificateFingerprint;

        private BuilderImpl() {
        }

        private BuilderImpl(AndroidApp model) {
            packageValue(model.packageValue);
            certificateFingerprint(model.certificateFingerprint);
        }

        public final String getPackageValue() {
            return packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getCertificateFingerprint() {
            return certificateFingerprint;
        }

        public final void setCertificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
        }

        @Override
        public final Builder certificateFingerprint(String certificateFingerprint) {
            this.certificateFingerprint = certificateFingerprint;
            return this;
        }

        @Override
        public AndroidApp build() {
            return new AndroidApp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
