/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cellular network communication infrastructure that the device uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CellSignals implements SdkPojo, Serializable, ToCopyableBuilder<CellSignals.Builder, CellSignals> {
    private static final SdkField<List<LteCellDetails>> LTE_CELL_DETAILS_FIELD = SdkField
            .<List<LteCellDetails>> builder(MarshallingType.LIST)
            .memberName("LteCellDetails")
            .getter(getter(CellSignals::lteCellDetails))
            .setter(setter(Builder::lteCellDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteCellDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LteCellDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(LteCellDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LTE_CELL_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LteCellDetails> lteCellDetails;

    private CellSignals(BuilderImpl builder) {
        this.lteCellDetails = builder.lteCellDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the LteCellDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLteCellDetails() {
        return lteCellDetails != null && !(lteCellDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Long-Term Evolution (LTE) network the device is connected to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLteCellDetails} method.
     * </p>
     * 
     * @return Information about the Long-Term Evolution (LTE) network the device is connected to.
     */
    public final List<LteCellDetails> lteCellDetails() {
        return lteCellDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLteCellDetails() ? lteCellDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellSignals)) {
            return false;
        }
        CellSignals other = (CellSignals) obj;
        return hasLteCellDetails() == other.hasLteCellDetails() && Objects.equals(lteCellDetails(), other.lteCellDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CellSignals").add("LteCellDetails", hasLteCellDetails() ? lteCellDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LteCellDetails":
            return Optional.ofNullable(clazz.cast(lteCellDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LteCellDetails", LTE_CELL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CellSignals, T> g) {
        return obj -> g.apply((CellSignals) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CellSignals> {
        /**
         * <p>
         * Information about the Long-Term Evolution (LTE) network the device is connected to.
         * </p>
         * 
         * @param lteCellDetails
         *        Information about the Long-Term Evolution (LTE) network the device is connected to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteCellDetails(Collection<LteCellDetails> lteCellDetails);

        /**
         * <p>
         * Information about the Long-Term Evolution (LTE) network the device is connected to.
         * </p>
         * 
         * @param lteCellDetails
         *        Information about the Long-Term Evolution (LTE) network the device is connected to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lteCellDetails(LteCellDetails... lteCellDetails);

        /**
         * <p>
         * Information about the Long-Term Evolution (LTE) network the device is connected to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.LteCellDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.location.model.LteCellDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.LteCellDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #lteCellDetails(List<LteCellDetails>)}.
         * 
         * @param lteCellDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.LteCellDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lteCellDetails(java.util.Collection<LteCellDetails>)
         */
        Builder lteCellDetails(Consumer<LteCellDetails.Builder>... lteCellDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<LteCellDetails> lteCellDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CellSignals model) {
            lteCellDetails(model.lteCellDetails);
        }

        public final List<LteCellDetails.Builder> getLteCellDetails() {
            List<LteCellDetails.Builder> result = CellSignalsLteCellDetailsListCopier.copyToBuilder(this.lteCellDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLteCellDetails(Collection<LteCellDetails.BuilderImpl> lteCellDetails) {
            this.lteCellDetails = CellSignalsLteCellDetailsListCopier.copyFromBuilder(lteCellDetails);
        }

        @Override
        public final Builder lteCellDetails(Collection<LteCellDetails> lteCellDetails) {
            this.lteCellDetails = CellSignalsLteCellDetailsListCopier.copy(lteCellDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteCellDetails(LteCellDetails... lteCellDetails) {
            lteCellDetails(Arrays.asList(lteCellDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteCellDetails(Consumer<LteCellDetails.Builder>... lteCellDetails) {
            lteCellDetails(Stream.of(lteCellDetails).map(c -> LteCellDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CellSignals build() {
            return new CellSignals(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
