/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GeofenceGeometryMultiPolygonListCopier {
    static List<List<List<List<Double>>>> copy(
            Collection<? extends Collection<? extends Collection<? extends Collection<Double>>>> geofenceGeometryMultiPolygonListParam) {
        List<List<List<List<Double>>>> list;
        if (geofenceGeometryMultiPolygonListParam == null
                || geofenceGeometryMultiPolygonListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<List<List<List<Double>>>> modifiableList = new ArrayList<>(geofenceGeometryMultiPolygonListParam.size());
            geofenceGeometryMultiPolygonListParam.forEach(entry -> {
                List<List<List<Double>>> list1;
                if (entry == null || entry instanceof SdkAutoConstructList) {
                    list1 = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<List<List<Double>>> modifiableList1 = new ArrayList<>(entry.size());
                    entry.forEach(entry1 -> {
                        List<List<Double>> list2;
                        if (entry1 == null || entry1 instanceof SdkAutoConstructList) {
                            list2 = DefaultSdkAutoConstructList.getInstance();
                        } else {
                            List<List<Double>> modifiableList2 = new ArrayList<>(entry1.size());
                            entry1.forEach(entry2 -> {
                                List<Double> list3;
                                if (entry2 == null || entry2 instanceof SdkAutoConstructList) {
                                    list3 = DefaultSdkAutoConstructList.getInstance();
                                } else {
                                    List<Double> modifiableList3 = new ArrayList<>(entry2);
                                    list3 = Collections.unmodifiableList(modifiableList3);
                                }
                                modifiableList2.add(list3);
                            });
                            list2 = Collections.unmodifiableList(modifiableList2);
                        }
                        modifiableList1.add(list2);
                    });
                    list1 = Collections.unmodifiableList(modifiableList1);
                }
                modifiableList.add(list1);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
