/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDevicePositionHistoryRequest extends LocationRequest implements
        ToCopyableBuilder<GetDevicePositionHistoryRequest.Builder, GetDevicePositionHistoryRequest> {
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackerName").getter(getter(GetDevicePositionHistoryRequest::trackerName))
            .setter(setter(Builder::trackerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(GetDevicePositionHistoryRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetDevicePositionHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Instant> START_TIME_INCLUSIVE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimeInclusive")
            .getter(getter(GetDevicePositionHistoryRequest::startTimeInclusive))
            .setter(setter(Builder::startTimeInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeInclusive").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_EXCLUSIVE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimeExclusive")
            .getter(getter(GetDevicePositionHistoryRequest::endTimeExclusive))
            .setter(setter(Builder::endTimeExclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeExclusive").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetDevicePositionHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKER_NAME_FIELD,
            DEVICE_ID_FIELD, NEXT_TOKEN_FIELD, START_TIME_INCLUSIVE_FIELD, END_TIME_EXCLUSIVE_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackerName;

    private final String deviceId;

    private final String nextToken;

    private final Instant startTimeInclusive;

    private final Instant endTimeExclusive;

    private final Integer maxResults;

    private GetDevicePositionHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.trackerName = builder.trackerName;
        this.deviceId = builder.deviceId;
        this.nextToken = builder.nextToken;
        this.startTimeInclusive = builder.startTimeInclusive;
        this.endTimeExclusive = builder.endTimeExclusive;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The tracker resource receiving the request for the device position history.
     * </p>
     * 
     * @return The tracker resource receiving the request for the device position history.
     */
    public final String trackerName() {
        return trackerName;
    }

    /**
     * <p>
     * The device whose position history you want to retrieve.
     * </p>
     * 
     * @return The device whose position history you want to retrieve.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The pagination token specifying which page of results to return in the response. If no token is provided, the
     * default page is the first page.
     * </p>
     * <p>
     * Default value: <code>null</code>
     * </p>
     * 
     * @return The pagination token specifying which page of results to return in the response. If no token is provided,
     *         the default page is the first page. </p>
     *         <p>
     *         Default value: <code>null</code>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify the start time for the position history in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request
     * is made.
     * </p>
     * <p>
     * Requirement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the start time for the position history in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the
     *         request is made.</p>
     *         <p>
     *         Requirement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.
     *         </p>
     *         </li>
     */
    public final Instant startTimeInclusive() {
        return startTimeInclusive;
    }

    /**
     * <p>
     * Specify the end time for the position history in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.
     * </p>
     * <p>
     * Requirement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify the end time for the position history in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is
     *         made.</p>
     *         <p>
     *         Requirement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The time specified for <code>EndTimeExclusive</code> must be after the time for
     *         <code>StartTimeInclusive</code>.
     *         </p>
     *         </li>
     */
    public final Instant endTimeExclusive() {
        return endTimeExclusive;
    }

    /**
     * <p>
     * An optional limit for the number of device positions returned in a single call.
     * </p>
     * <p>
     * Default value: <code>100</code>
     * </p>
     * 
     * @return An optional limit for the number of device positions returned in a single call.</p>
     *         <p>
     *         Default value: <code>100</code>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeExclusive());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePositionHistoryRequest)) {
            return false;
        }
        GetDevicePositionHistoryRequest other = (GetDevicePositionHistoryRequest) obj;
        return Objects.equals(trackerName(), other.trackerName()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTimeInclusive(), other.startTimeInclusive())
                && Objects.equals(endTimeExclusive(), other.endTimeExclusive())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDevicePositionHistoryRequest").add("TrackerName", trackerName()).add("DeviceId", deviceId())
                .add("NextToken", nextToken())
                .add("StartTimeInclusive", startTimeInclusive() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EndTimeExclusive", endTimeExclusive() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackerName":
            return Optional.ofNullable(clazz.cast(trackerName()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StartTimeInclusive":
            return Optional.ofNullable(clazz.cast(startTimeInclusive()));
        case "EndTimeExclusive":
            return Optional.ofNullable(clazz.cast(endTimeExclusive()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackerName", TRACKER_NAME_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("StartTimeInclusive", START_TIME_INCLUSIVE_FIELD);
        map.put("EndTimeExclusive", END_TIME_EXCLUSIVE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePositionHistoryRequest, T> g) {
        return obj -> g.apply((GetDevicePositionHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDevicePositionHistoryRequest> {
        /**
         * <p>
         * The tracker resource receiving the request for the device position history.
         * </p>
         * 
         * @param trackerName
         *        The tracker resource receiving the request for the device position history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackerName(String trackerName);

        /**
         * <p>
         * The device whose position history you want to retrieve.
         * </p>
         * 
         * @param deviceId
         *        The device whose position history you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The pagination token specifying which page of results to return in the response. If no token is provided, the
         * default page is the first page.
         * </p>
         * <p>
         * Default value: <code>null</code>
         * </p>
         * 
         * @param nextToken
         *        The pagination token specifying which page of results to return in the response. If no token is
         *        provided, the default page is the first page. </p>
         *        <p>
         *        Default value: <code>null</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify the start time for the position history in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the
         * request is made.
         * </p>
         * <p>
         * Requirement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTimeInclusive
         *        Specify the start time for the position history in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that
         *        the request is made.</p>
         *        <p>
         *        Requirement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeInclusive(Instant startTimeInclusive);

        /**
         * <p>
         * Specify the end time for the position history in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.
         * </p>
         * <p>
         * Requirement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The time specified for <code>EndTimeExclusive</code> must be after the time for
         * <code>StartTimeInclusive</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endTimeExclusive
         *        Specify the end time for the position history in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is
         *        made.</p>
         *        <p>
         *        Requirement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The time specified for <code>EndTimeExclusive</code> must be after the time for
         *        <code>StartTimeInclusive</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeExclusive(Instant endTimeExclusive);

        /**
         * <p>
         * An optional limit for the number of device positions returned in a single call.
         * </p>
         * <p>
         * Default value: <code>100</code>
         * </p>
         * 
         * @param maxResults
         *        An optional limit for the number of device positions returned in a single call.</p>
         *        <p>
         *        Default value: <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String trackerName;

        private String deviceId;

        private String nextToken;

        private Instant startTimeInclusive;

        private Instant endTimeExclusive;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePositionHistoryRequest model) {
            super(model);
            trackerName(model.trackerName);
            deviceId(model.deviceId);
            nextToken(model.nextToken);
            startTimeInclusive(model.startTimeInclusive);
            endTimeExclusive(model.endTimeExclusive);
            maxResults(model.maxResults);
        }

        public final String getTrackerName() {
            return trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTimeInclusive() {
            return startTimeInclusive;
        }

        public final void setStartTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
        }

        @Override
        public final Builder startTimeInclusive(Instant startTimeInclusive) {
            this.startTimeInclusive = startTimeInclusive;
            return this;
        }

        public final Instant getEndTimeExclusive() {
            return endTimeExclusive;
        }

        public final void setEndTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
        }

        @Override
        public final Builder endTimeExclusive(Instant endTimeExclusive) {
            this.endTimeExclusive = endTimeExclusive;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePositionHistoryRequest build() {
            return new GetDevicePositionHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
