/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMapTileRequest extends LocationRequest implements
        ToCopyableBuilder<GetMapTileRequest.Builder, GetMapTileRequest> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(GetMapTileRequest::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MapName").build()).build();

    private static final SdkField<String> Z_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Z")
            .getter(getter(GetMapTileRequest::z)).setter(setter(Builder::z))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Z").build()).build();

    private static final SdkField<String> X_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("X")
            .getter(getter(GetMapTileRequest::x)).setter(setter(Builder::x))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("X").build()).build();

    private static final SdkField<String> Y_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Y")
            .getter(getter(GetMapTileRequest::y)).setter(setter(Builder::y))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Y").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(GetMapTileRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD, Z_FIELD,
            X_FIELD, Y_FIELD, KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mapName;

    private final String z;

    private final String x;

    private final String y;

    private final String key;

    private GetMapTileRequest(BuilderImpl builder) {
        super(builder);
        this.mapName = builder.mapName;
        this.z = builder.z;
        this.x = builder.x;
        this.y = builder.y;
        this.key = builder.key;
    }

    /**
     * <p>
     * The map resource to retrieve the map tiles from.
     * </p>
     * 
     * @return The map resource to retrieve the map tiles from.
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * The zoom value for the map tile.
     * </p>
     * 
     * @return The zoom value for the map tile.
     */
    public final String z() {
        return z;
    }

    /**
     * <p>
     * The X axis value for the map tile.
     * </p>
     * 
     * @return The X axis value for the map tile.
     */
    public final String x() {
        return x;
    }

    /**
     * <p>
     * The Y axis value for the map tile.
     * </p>
     * 
     * @return The Y axis value for the map tile.
     */
    public final String y() {
        return y;
    }

    /**
     * <p>
     * The optional <a href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API
     * key</a> to authorize the request.
     * </p>
     * 
     * @return The optional <a
     *         href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API key</a> to
     *         authorize the request.
     */
    public final String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(z());
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMapTileRequest)) {
            return false;
        }
        GetMapTileRequest other = (GetMapTileRequest) obj;
        return Objects.equals(mapName(), other.mapName()) && Objects.equals(z(), other.z()) && Objects.equals(x(), other.x())
                && Objects.equals(y(), other.y()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMapTileRequest").add("MapName", mapName())
                .add("Z", z() == null ? null : "*** Sensitive Data Redacted ***")
                .add("X", x() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Y", y() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "Z":
            return Optional.ofNullable(clazz.cast(z()));
        case "X":
            return Optional.ofNullable(clazz.cast(x()));
        case "Y":
            return Optional.ofNullable(clazz.cast(y()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MapName", MAP_NAME_FIELD);
        map.put("Z", Z_FIELD);
        map.put("X", X_FIELD);
        map.put("Y", Y_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMapTileRequest, T> g) {
        return obj -> g.apply((GetMapTileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMapTileRequest> {
        /**
         * <p>
         * The map resource to retrieve the map tiles from.
         * </p>
         * 
         * @param mapName
         *        The map resource to retrieve the map tiles from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * The zoom value for the map tile.
         * </p>
         * 
         * @param z
         *        The zoom value for the map tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder z(String z);

        /**
         * <p>
         * The X axis value for the map tile.
         * </p>
         * 
         * @param x
         *        The X axis value for the map tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(String x);

        /**
         * <p>
         * The Y axis value for the map tile.
         * </p>
         * 
         * @param y
         *        The Y axis value for the map tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(String y);

        /**
         * <p>
         * The optional <a href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API
         * key</a> to authorize the request.
         * </p>
         * 
         * @param key
         *        The optional <a
         *        href="https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html">API key</a> to
         *        authorize the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String mapName;

        private String z;

        private String x;

        private String y;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMapTileRequest model) {
            super(model);
            mapName(model.mapName);
            z(model.z);
            x(model.x);
            y(model.y);
            key(model.key);
        }

        public final String getMapName() {
            return mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getZ() {
            return z;
        }

        public final void setZ(String z) {
            this.z = z;
        }

        @Override
        public final Builder z(String z) {
            this.z = z;
            return this;
        }

        public final String getX() {
            return x;
        }

        public final void setX(String x) {
            this.x = x;
        }

        @Override
        public final Builder x(String x) {
            this.x = x;
            return this;
        }

        public final String getY() {
            return y;
        }

        public final void setY(String y) {
            this.y = y;
        }

        @Override
        public final Builder y(String y) {
            this.y = y;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMapTileRequest build() {
            return new GetMapTileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
