/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An API key resource listed in your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeysResponseEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListKeysResponseEntry.Builder, ListKeysResponseEntry> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(ListKeysResponseEntry::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<Instant> EXPIRE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpireTime")
            .getter(getter(ListKeysResponseEntry::expireTime))
            .setter(setter(Builder::expireTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListKeysResponseEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ApiKeyRestrictions> RESTRICTIONS_FIELD = SdkField
            .<ApiKeyRestrictions> builder(MarshallingType.SDK_POJO).memberName("Restrictions")
            .getter(getter(ListKeysResponseEntry::restrictions)).setter(setter(Builder::restrictions))
            .constructor(ApiKeyRestrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(ListKeysResponseEntry::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(ListKeysResponseEntry::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            EXPIRE_TIME_FIELD, DESCRIPTION_FIELD, RESTRICTIONS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyName;

    private final Instant expireTime;

    private final String description;

    private final ApiKeyRestrictions restrictions;

    private final Instant createTime;

    private final Instant updateTime;

    private ListKeysResponseEntry(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.expireTime = builder.expireTime;
        this.description = builder.description;
        this.restrictions = builder.restrictions;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The name of the API key resource.
     * </p>
     * 
     * @return The name of the API key resource.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The timestamp for when the API key resource will expire, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the API key resource will expire, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant expireTime() {
        return expireTime;
    }

    /**
     * <p>
     * The optional description for the API key resource.
     * </p>
     * 
     * @return The optional description for the API key resource.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Restrictions property for this object.
     * 
     * @return The value of the Restrictions property for this object.
     */
    public final ApiKeyRestrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * The timestamp of when the API key was created, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp of when the API key was created, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The timestamp of when the API key was last updated, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp of when the API key was last updated, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(expireTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponseEntry)) {
            return false;
        }
        ListKeysResponseEntry other = (ListKeysResponseEntry) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(expireTime(), other.expireTime())
                && Objects.equals(description(), other.description()) && Objects.equals(restrictions(), other.restrictions())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKeysResponseEntry").add("KeyName", keyName())
                .add("ExpireTime", expireTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description()).add("Restrictions", restrictions())
                .add("CreateTime", createTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdateTime", updateTime() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "ExpireTime":
            return Optional.ofNullable(clazz.cast(expireTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("ExpireTime", EXPIRE_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("UpdateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeysResponseEntry, T> g) {
        return obj -> g.apply((ListKeysResponseEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListKeysResponseEntry> {
        /**
         * <p>
         * The name of the API key resource.
         * </p>
         * 
         * @param keyName
         *        The name of the API key resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The timestamp for when the API key resource will expire, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param expireTime
         *        The timestamp for when the API key resource will expire, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expireTime(Instant expireTime);

        /**
         * <p>
         * The optional description for the API key resource.
         * </p>
         * 
         * @param description
         *        The optional description for the API key resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * @param restrictions
         *        The new value for the Restrictions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(ApiKeyRestrictions restrictions);

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApiKeyRestrictions.Builder} avoiding the
         * need to create one manually via {@link ApiKeyRestrictions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiKeyRestrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(ApiKeyRestrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link ApiKeyRestrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(ApiKeyRestrictions)
         */
        default Builder restrictions(Consumer<ApiKeyRestrictions.Builder> restrictions) {
            return restrictions(ApiKeyRestrictions.builder().applyMutation(restrictions).build());
        }

        /**
         * <p>
         * The timestamp of when the API key was created, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp of when the API key was created, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The timestamp of when the API key was last updated, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp of when the API key was last updated, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String keyName;

        private Instant expireTime;

        private String description;

        private ApiKeyRestrictions restrictions;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponseEntry model) {
            keyName(model.keyName);
            expireTime(model.expireTime);
            description(model.description);
            restrictions(model.restrictions);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getExpireTime() {
            return expireTime;
        }

        public final void setExpireTime(Instant expireTime) {
            this.expireTime = expireTime;
        }

        @Override
        public final Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ApiKeyRestrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(ApiKeyRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(ApiKeyRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ListKeysResponseEntry build() {
            return new ListKeysResponseEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
