/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the truck's weight specifications. Used to avoid roads that can't support or allow the total
 * weight for requests that specify <code>TravelMode</code> as <code>Truck</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TruckWeight implements SdkPojo, Serializable, ToCopyableBuilder<TruckWeight.Builder, TruckWeight> {
    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Total")
            .getter(getter(TruckWeight::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(TruckWeight::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double total;

    private final String unit;

    private TruckWeight(BuilderImpl builder) {
        this.total = builder.total;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The total weight of the truck.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For example, <code>3500</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The total weight of the truck. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For example, <code>3500</code>.
     *         </p>
     *         </li>
     */
    public final Double total() {
        return total;
    }

    /**
     * <p>
     * The unit of measurement to use for the truck weight.
     * </p>
     * <p>
     * Default Value: <code>Kilograms</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link VehicleWeightUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement to use for the truck weight.</p>
     *         <p>
     *         Default Value: <code>Kilograms</code>
     * @see VehicleWeightUnit
     */
    public final VehicleWeightUnit unit() {
        return VehicleWeightUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measurement to use for the truck weight.
     * </p>
     * <p>
     * Default Value: <code>Kilograms</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link VehicleWeightUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement to use for the truck weight.</p>
     *         <p>
     *         Default Value: <code>Kilograms</code>
     * @see VehicleWeightUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TruckWeight)) {
            return false;
        }
        TruckWeight other = (TruckWeight) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TruckWeight").add("Total", total() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Total", TOTAL_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TruckWeight, T> g) {
        return obj -> g.apply((TruckWeight) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TruckWeight> {
        /**
         * <p>
         * The total weight of the truck.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For example, <code>3500</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param total
         *        The total weight of the truck. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For example, <code>3500</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * The unit of measurement to use for the truck weight.
         * </p>
         * <p>
         * Default Value: <code>Kilograms</code>
         * </p>
         * 
         * @param unit
         *        The unit of measurement to use for the truck weight.</p>
         *        <p>
         *        Default Value: <code>Kilograms</code>
         * @see VehicleWeightUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleWeightUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measurement to use for the truck weight.
         * </p>
         * <p>
         * Default Value: <code>Kilograms</code>
         * </p>
         * 
         * @param unit
         *        The unit of measurement to use for the truck weight.</p>
         *        <p>
         *        Default Value: <code>Kilograms</code>
         * @see VehicleWeightUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleWeightUnit
         */
        Builder unit(VehicleWeightUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Double total;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(TruckWeight model) {
            total(model.total);
            unit(model.unit);
        }

        public final Double getTotal() {
            return total;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(VehicleWeightUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public TruckWeight build() {
            return new TruckWeight(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
