/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeyRequest extends LocationRequest implements
        ToCopyableBuilder<UpdateKeyRequest.Builder, UpdateKeyRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(UpdateKeyRequest::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateKeyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> EXPIRE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpireTime")
            .getter(getter(UpdateKeyRequest::expireTime))
            .setter(setter(Builder::expireTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpireTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> NO_EXPIRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoExpiry").getter(getter(UpdateKeyRequest::noExpiry)).setter(setter(Builder::noExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoExpiry").build()).build();

    private static final SdkField<Boolean> FORCE_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceUpdate").getter(getter(UpdateKeyRequest::forceUpdate)).setter(setter(Builder::forceUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceUpdate").build()).build();

    private static final SdkField<ApiKeyRestrictions> RESTRICTIONS_FIELD = SdkField
            .<ApiKeyRestrictions> builder(MarshallingType.SDK_POJO).memberName("Restrictions")
            .getter(getter(UpdateKeyRequest::restrictions)).setter(setter(Builder::restrictions))
            .constructor(ApiKeyRestrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD,
            DESCRIPTION_FIELD, EXPIRE_TIME_FIELD, NO_EXPIRY_FIELD, FORCE_UPDATE_FIELD, RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyName;

    private final String description;

    private final Instant expireTime;

    private final Boolean noExpiry;

    private final Boolean forceUpdate;

    private final ApiKeyRestrictions restrictions;

    private UpdateKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.description = builder.description;
        this.expireTime = builder.expireTime;
        this.noExpiry = builder.noExpiry;
        this.forceUpdate = builder.forceUpdate;
        this.restrictions = builder.restrictions;
    }

    /**
     * <p>
     * The name of the API key resource to update.
     * </p>
     * 
     * @return The name of the API key resource to update.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Updates the description for the API key resource.
     * </p>
     * 
     * @return Updates the description for the API key resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the timestamp for when the API key resource will expire in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return Updates the timestamp for when the API key resource will expire in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant expireTime() {
        return expireTime;
    }

    /**
     * <p>
     * Whether the API key should expire. Set to <code>true</code> to set the API key to have no expiration time.
     * </p>
     * 
     * @return Whether the API key should expire. Set to <code>true</code> to set the API key to have no expiration
     *         time.
     */
    public final Boolean noExpiry() {
        return noExpiry;
    }

    /**
     * <p>
     * The boolean flag to be included for updating <code>ExpireTime</code> or <code>Restrictions</code> details.
     * </p>
     * <p>
     * Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days.
     * </p>
     * <p>
     * <code>False</code> if force update is not preferred
     * </p>
     * <p>
     * Default value: <code>False</code>
     * </p>
     * 
     * @return The boolean flag to be included for updating <code>ExpireTime</code> or <code>Restrictions</code>
     *         details.</p>
     *         <p>
     *         Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days.
     *         </p>
     *         <p>
     *         <code>False</code> if force update is not preferred
     *         </p>
     *         <p>
     *         Default value: <code>False</code>
     */
    public final Boolean forceUpdate() {
        return forceUpdate;
    }

    /**
     * <p>
     * Updates the API key restrictions for the API key resource.
     * </p>
     * 
     * @return Updates the API key restrictions for the API key resource.
     */
    public final ApiKeyRestrictions restrictions() {
        return restrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(expireTime());
        hashCode = 31 * hashCode + Objects.hashCode(noExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(forceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRequest)) {
            return false;
        }
        UpdateKeyRequest other = (UpdateKeyRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(description(), other.description())
                && Objects.equals(expireTime(), other.expireTime()) && Objects.equals(noExpiry(), other.noExpiry())
                && Objects.equals(forceUpdate(), other.forceUpdate()) && Objects.equals(restrictions(), other.restrictions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeyRequest").add("KeyName", keyName()).add("Description", description())
                .add("ExpireTime", expireTime() == null ? null : "*** Sensitive Data Redacted ***").add("NoExpiry", noExpiry())
                .add("ForceUpdate", forceUpdate()).add("Restrictions", restrictions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExpireTime":
            return Optional.ofNullable(clazz.cast(expireTime()));
        case "NoExpiry":
            return Optional.ofNullable(clazz.cast(noExpiry()));
        case "ForceUpdate":
            return Optional.ofNullable(clazz.cast(forceUpdate()));
        case "Restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExpireTime", EXPIRE_TIME_FIELD);
        map.put("NoExpiry", NO_EXPIRY_FIELD);
        map.put("ForceUpdate", FORCE_UPDATE_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRequest, T> g) {
        return obj -> g.apply((UpdateKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeyRequest> {
        /**
         * <p>
         * The name of the API key resource to update.
         * </p>
         * 
         * @param keyName
         *        The name of the API key resource to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Updates the description for the API key resource.
         * </p>
         * 
         * @param description
         *        Updates the description for the API key resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the timestamp for when the API key resource will expire in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param expireTime
         *        Updates the timestamp for when the API key resource will expire in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expireTime(Instant expireTime);

        /**
         * <p>
         * Whether the API key should expire. Set to <code>true</code> to set the API key to have no expiration time.
         * </p>
         * 
         * @param noExpiry
         *        Whether the API key should expire. Set to <code>true</code> to set the API key to have no expiration
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noExpiry(Boolean noExpiry);

        /**
         * <p>
         * The boolean flag to be included for updating <code>ExpireTime</code> or <code>Restrictions</code> details.
         * </p>
         * <p>
         * Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days.
         * </p>
         * <p>
         * <code>False</code> if force update is not preferred
         * </p>
         * <p>
         * Default value: <code>False</code>
         * </p>
         * 
         * @param forceUpdate
         *        The boolean flag to be included for updating <code>ExpireTime</code> or <code>Restrictions</code>
         *        details.</p>
         *        <p>
         *        Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days.
         *        </p>
         *        <p>
         *        <code>False</code> if force update is not preferred
         *        </p>
         *        <p>
         *        Default value: <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceUpdate(Boolean forceUpdate);

        /**
         * <p>
         * Updates the API key restrictions for the API key resource.
         * </p>
         * 
         * @param restrictions
         *        Updates the API key restrictions for the API key resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(ApiKeyRestrictions restrictions);

        /**
         * <p>
         * Updates the API key restrictions for the API key resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiKeyRestrictions.Builder} avoiding the
         * need to create one manually via {@link ApiKeyRestrictions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiKeyRestrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(ApiKeyRestrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link ApiKeyRestrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(ApiKeyRestrictions)
         */
        default Builder restrictions(Consumer<ApiKeyRestrictions.Builder> restrictions) {
            return restrictions(ApiKeyRestrictions.builder().applyMutation(restrictions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String keyName;

        private String description;

        private Instant expireTime;

        private Boolean noExpiry;

        private Boolean forceUpdate;

        private ApiKeyRestrictions restrictions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRequest model) {
            super(model);
            keyName(model.keyName);
            description(model.description);
            expireTime(model.expireTime);
            noExpiry(model.noExpiry);
            forceUpdate(model.forceUpdate);
            restrictions(model.restrictions);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getExpireTime() {
            return expireTime;
        }

        public final void setExpireTime(Instant expireTime) {
            this.expireTime = expireTime;
        }

        @Override
        public final Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public final Boolean getNoExpiry() {
            return noExpiry;
        }

        public final void setNoExpiry(Boolean noExpiry) {
            this.noExpiry = noExpiry;
        }

        @Override
        public final Builder noExpiry(Boolean noExpiry) {
            this.noExpiry = noExpiry;
            return this;
        }

        public final Boolean getForceUpdate() {
            return forceUpdate;
        }

        public final void setForceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        @Override
        public final Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public final ApiKeyRestrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(ApiKeyRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(ApiKeyRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyRequest build() {
            return new UpdateKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
