/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateExportTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateExportTaskRequest.Builder, CreateExportTaskRequest> {
    private final String taskName;

    private final String logGroupName;

    private final String logStreamNamePrefix;

    private final Long from;

    private final Long to;

    private final String destination;

    private final String destinationPrefix;

    private CreateExportTaskRequest(BuilderImpl builder) {
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
    }

    /**
     * <p>
     * The name of the export task.
     * </p>
     * 
     * @return The name of the export task.
     */
    public String taskName() {
        return taskName;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
     * applied.
     * </p>
     * 
     * @return Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
     *         applied.
     */
    public String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * <p>
     * The start time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     * UTC. Events with a timestamp earlier than this time are not exported.
     * </p>
     * 
     * @return The start time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC. Events with a timestamp earlier than this time are not exported.
     */
    public Long from() {
        return from;
    }

    /**
     * <p>
     * The end time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     * UTC. Events with a timestamp later than this time are not exported.
     * </p>
     * 
     * @return The end time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC. Events with a timestamp later than this time are not exported.
     */
    public Long to() {
        return to;
    }

    /**
     * <p>
     * The name of S3 bucket for the exported log data. The bucket must be in the same AWS region.
     * </p>
     * 
     * @return The name of S3 bucket for the exported log data. The bucket must be in the same AWS region.
     */
    public String destination() {
        return destination;
    }

    /**
     * <p>
     * The prefix used as the start of the key for every object exported. If you don't specify a value, the default is
     * <code>exportedlogs</code>.
     * </p>
     * 
     * @return The prefix used as the start of the key for every object exported. If you don't specify a value, the
     *         default is <code>exportedlogs</code>.
     */
    public String destinationPrefix() {
        return destinationPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskName() == null) ? 0 : taskName().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamNamePrefix() == null) ? 0 : logStreamNamePrefix().hashCode());
        hashCode = 31 * hashCode + ((from() == null) ? 0 : from().hashCode());
        hashCode = 31 * hashCode + ((to() == null) ? 0 : to().hashCode());
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        hashCode = 31 * hashCode + ((destinationPrefix() == null) ? 0 : destinationPrefix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportTaskRequest)) {
            return false;
        }
        CreateExportTaskRequest other = (CreateExportTaskRequest) obj;
        if (other.taskName() == null ^ this.taskName() == null) {
            return false;
        }
        if (other.taskName() != null && !other.taskName().equals(this.taskName())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNamePrefix() == null ^ this.logStreamNamePrefix() == null) {
            return false;
        }
        if (other.logStreamNamePrefix() != null && !other.logStreamNamePrefix().equals(this.logStreamNamePrefix())) {
            return false;
        }
        if (other.from() == null ^ this.from() == null) {
            return false;
        }
        if (other.from() != null && !other.from().equals(this.from())) {
            return false;
        }
        if (other.to() == null ^ this.to() == null) {
            return false;
        }
        if (other.to() != null && !other.to().equals(this.to())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.destinationPrefix() == null ^ this.destinationPrefix() == null) {
            return false;
        }
        if (other.destinationPrefix() != null && !other.destinationPrefix().equals(this.destinationPrefix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskName() != null) {
            sb.append("TaskName: ").append(taskName()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamNamePrefix() != null) {
            sb.append("LogStreamNamePrefix: ").append(logStreamNamePrefix()).append(",");
        }
        if (from() != null) {
            sb.append("From: ").append(from()).append(",");
        }
        if (to() != null) {
            sb.append("To: ").append(to()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (destinationPrefix() != null) {
            sb.append("DestinationPrefix: ").append(destinationPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateExportTaskRequest> {
        /**
         * <p>
         * The name of the export task.
         * </p>
         * 
         * @param taskName
         *        The name of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskName(String taskName);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is
         * applied.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter
         *        is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * The start time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970
         * 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.
         * </p>
         * 
         * @param from
         *        The start time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC. Events with a timestamp earlier than this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Long from);

        /**
         * <p>
         * The end time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         * UTC. Events with a timestamp later than this time are not exported.
         * </p>
         * 
         * @param to
         *        The end time of the range for the request, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC. Events with a timestamp later than this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Long to);

        /**
         * <p>
         * The name of S3 bucket for the exported log data. The bucket must be in the same AWS region.
         * </p>
         * 
         * @param destination
         *        The name of S3 bucket for the exported log data. The bucket must be in the same AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The prefix used as the start of the key for every object exported. If you don't specify a value, the default
         * is <code>exportedlogs</code>.
         * </p>
         * 
         * @param destinationPrefix
         *        The prefix used as the start of the key for every object exported. If you don't specify a value, the
         *        default is <code>exportedlogs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefix(String destinationPrefix);
    }

    private static final class BuilderImpl implements Builder {
        private String taskName;

        private String logGroupName;

        private String logStreamNamePrefix;

        private Long from;

        private Long to;

        private String destination;

        private String destinationPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportTaskRequest model) {
            setTaskName(model.taskName);
            setLogGroupName(model.logGroupName);
            setLogStreamNamePrefix(model.logStreamNamePrefix);
            setFrom(model.from);
            setTo(model.to);
            setDestination(model.destination);
            setDestinationPrefix(model.destinationPrefix);
        }

        public final String getTaskName() {
            return taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final Long getFrom() {
            return from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        @Override
        public CreateExportTaskRequest build() {
            return new CreateExportTaskRequest(this);
        }
    }
}
