/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDestinationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteDestinationRequest.Builder, DeleteDestinationRequest> {
    private final String destinationName;

    private DeleteDestinationRequest(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
    }

    /**
     * <p>
     * The name of the destination.
     * </p>
     * 
     * @return The name of the destination.
     */
    public String destinationName() {
        return destinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationName() == null) ? 0 : destinationName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDestinationRequest)) {
            return false;
        }
        DeleteDestinationRequest other = (DeleteDestinationRequest) obj;
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationName() != null) {
            sb.append("DestinationName: ").append(destinationName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteDestinationRequest> {
        /**
         * <p>
         * The name of the destination.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDestinationRequest model) {
            setDestinationName(model.destinationName);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public DeleteDestinationRequest build() {
            return new DeleteDestinationRequest(this);
        }
    }
}
