/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDestinationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDestinationsRequest.Builder, DescribeDestinationsRequest> {
    private final String destinationNamePrefix;

    private final String nextToken;

    private final Integer limit;

    private DescribeDestinationsRequest(BuilderImpl builder) {
        this.destinationNamePrefix = builder.destinationNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The prefix to match. If you don't specify a value, no prefix filter is applied.
     * </p>
     * 
     * @return The prefix to match. If you don't specify a value, no prefix filter is applied.
     */
    public String destinationNamePrefix() {
        return destinationNamePrefix;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationNamePrefix() == null) ? 0 : destinationNamePrefix().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDestinationsRequest)) {
            return false;
        }
        DescribeDestinationsRequest other = (DescribeDestinationsRequest) obj;
        if (other.destinationNamePrefix() == null ^ this.destinationNamePrefix() == null) {
            return false;
        }
        if (other.destinationNamePrefix() != null && !other.destinationNamePrefix().equals(this.destinationNamePrefix())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationNamePrefix() != null) {
            sb.append("DestinationNamePrefix: ").append(destinationNamePrefix()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDestinationsRequest> {
        /**
         * <p>
         * The prefix to match. If you don't specify a value, no prefix filter is applied.
         * </p>
         * 
         * @param destinationNamePrefix
         *        The prefix to match. If you don't specify a value, no prefix filter is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationNamePrefix(String destinationNamePrefix);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationNamePrefix;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDestinationsRequest model) {
            setDestinationNamePrefix(model.destinationNamePrefix);
            setNextToken(model.nextToken);
            setLimit(model.limit);
        }

        public final String getDestinationNamePrefix() {
            return destinationNamePrefix;
        }

        @Override
        public final Builder destinationNamePrefix(String destinationNamePrefix) {
            this.destinationNamePrefix = destinationNamePrefix;
            return this;
        }

        public final void setDestinationNamePrefix(String destinationNamePrefix) {
            this.destinationNamePrefix = destinationNamePrefix;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DescribeDestinationsRequest build() {
            return new DescribeDestinationsRequest(this);
        }
    }
}
