/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDestinationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDestinationsResponse.Builder, DescribeDestinationsResponse> {
    private final List<Destination> destinations;

    private final String nextToken;

    private DescribeDestinationsResponse(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The destinations.
     * </p>
     * 
     * @return The destinations.
     */
    public List<Destination> destinations() {
        return destinations;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinations() == null) ? 0 : destinations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDestinationsResponse)) {
            return false;
        }
        DescribeDestinationsResponse other = (DescribeDestinationsResponse) obj;
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinations() != null) {
            sb.append("Destinations: ").append(destinations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDestinationsResponse> {
        /**
         * <p>
         * The destinations.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<Destination> destinations);

        /**
         * <p>
         * The destinations.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDestinations(java.util.Collection)} or {@link #withDestinations(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Destination... destinations);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Destination> destinations = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDestinationsResponse model) {
            setDestinations(model.destinations);
            setNextToken(model.nextToken);
        }

        public final Collection<Destination> getDestinations() {
            return destinations;
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList<>(destinations.length);
            }
            for (Destination e : destinations) {
                this.destinations.add(e);
            }
            return this;
        }

        public final void setDestinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
        }

        @SafeVarargs
        public final void setDestinations(Destination... destinations) {
            if (this.destinations == null) {
                this.destinations = new SdkInternalList<>(destinations.length);
            }
            for (Destination e : destinations) {
                this.destinations.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDestinationsResponse build() {
            return new DescribeDestinationsResponse(this);
        }
    }
}
