/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeExportTasksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeExportTasksRequest.Builder, DescribeExportTasksRequest> {
    private final String taskId;

    private final String statusCode;

    private final String nextToken;

    private final Integer limit;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.statusCode = builder.statusCode;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.
     * </p>
     * 
     * @return The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The status code of the export task. Specifying a status code filters the results to zero or more export tasks.
     * </p>
     * 
     * @return The status code of the export task. Specifying a status code filters the results to zero or more export
     *         tasks.
     * @see ExportTaskStatusCode
     */
    public String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskId() == null) ? 0 : taskId().hashCode());
        hashCode = 31 * hashCode + ((statusCode() == null) ? 0 : statusCode().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest) obj;
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskId() != null) {
            sb.append("TaskId: ").append(taskId()).append(",");
        }
        if (statusCode() != null) {
            sb.append("StatusCode: ").append(statusCode()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeExportTasksRequest> {
        /**
         * <p>
         * The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.
         * </p>
         * 
         * @param taskId
         *        The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The status code of the export task. Specifying a status code filters the results to zero or more export
         * tasks.
         * </p>
         * 
         * @param statusCode
         *        The status code of the export task. Specifying a status code filters the results to zero or more
         *        export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The status code of the export task. Specifying a status code filters the results to zero or more export
         * tasks.
         * </p>
         * 
         * @param statusCode
         *        The status code of the export task. Specifying a status code filters the results to zero or more
         *        export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskStatusCode
         */
        Builder statusCode(ExportTaskStatusCode statusCode);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String taskId;

        private String statusCode;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            setTaskId(model.taskId);
            setStatusCode(model.statusCode);
            setNextToken(model.nextToken);
            setLimit(model.limit);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ExportTaskStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final void setStatusCode(ExportTaskStatusCode statusCode) {
            this.statusCode(statusCode.toString());
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }
    }
}
