/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeExportTasksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private final List<ExportTask> exportTasks;

    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        this.exportTasks = builder.exportTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The export tasks.
     * </p>
     * 
     * @return The export tasks.
     */
    public List<ExportTask> exportTasks() {
        return exportTasks;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((exportTasks() == null) ? 0 : exportTasks().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        if (other.exportTasks() == null ^ this.exportTasks() == null) {
            return false;
        }
        if (other.exportTasks() != null && !other.exportTasks().equals(this.exportTasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (exportTasks() != null) {
            sb.append("ExportTasks: ").append(exportTasks()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * The export tasks.
         * </p>
         * 
         * @param exportTasks
         *        The export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(Collection<ExportTask> exportTasks);

        /**
         * <p>
         * The export tasks.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setExportTasks(java.util.Collection)} or {@link #withExportTasks(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param exportTasks
         *        The export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(ExportTask... exportTasks);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ExportTask> exportTasks = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            setExportTasks(model.exportTasks);
            setNextToken(model.nextToken);
        }

        public final Collection<ExportTask> getExportTasks() {
            return exportTasks;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask... exportTasks) {
            if (this.exportTasks == null) {
                this.exportTasks = new SdkInternalList<>(exportTasks.length);
            }
            for (ExportTask e : exportTasks) {
                this.exportTasks.add(e);
            }
            return this;
        }

        public final void setExportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
        }

        @SafeVarargs
        public final void setExportTasks(ExportTask... exportTasks) {
            if (this.exportTasks == null) {
                this.exportTasks = new SdkInternalList<>(exportTasks.length);
            }
            for (ExportTask e : exportTasks) {
                this.exportTasks.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }
    }
}
