/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLogGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeLogGroupsRequest.Builder, DescribeLogGroupsRequest> {
    private final String logGroupNamePrefix;

    private final String nextToken;

    private final Integer limit;

    private DescribeLogGroupsRequest(BuilderImpl builder) {
        this.logGroupNamePrefix = builder.logGroupNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The prefix to match.
     * </p>
     * 
     * @return The prefix to match.
     */
    public String logGroupNamePrefix() {
        return logGroupNamePrefix;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupNamePrefix() == null) ? 0 : logGroupNamePrefix().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsRequest)) {
            return false;
        }
        DescribeLogGroupsRequest other = (DescribeLogGroupsRequest) obj;
        if (other.logGroupNamePrefix() == null ^ this.logGroupNamePrefix() == null) {
            return false;
        }
        if (other.logGroupNamePrefix() != null && !other.logGroupNamePrefix().equals(this.logGroupNamePrefix())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupNamePrefix() != null) {
            sb.append("LogGroupNamePrefix: ").append(logGroupNamePrefix()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLogGroupsRequest> {
        /**
         * <p>
         * The prefix to match.
         * </p>
         * 
         * @param logGroupNamePrefix
         *        The prefix to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupNamePrefix(String logGroupNamePrefix);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupNamePrefix;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsRequest model) {
            setLogGroupNamePrefix(model.logGroupNamePrefix);
            setNextToken(model.nextToken);
            setLimit(model.limit);
        }

        public final String getLogGroupNamePrefix() {
            return logGroupNamePrefix;
        }

        @Override
        public final Builder logGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
            return this;
        }

        public final void setLogGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DescribeLogGroupsRequest build() {
            return new DescribeLogGroupsRequest(this);
        }
    }
}
