/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLogGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLogGroupsResponse.Builder, DescribeLogGroupsResponse> {
    private final List<LogGroup> logGroups;

    private final String nextToken;

    private DescribeLogGroupsResponse(BuilderImpl builder) {
        this.logGroups = builder.logGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The log groups.
     * </p>
     * 
     * @return The log groups.
     */
    public List<LogGroup> logGroups() {
        return logGroups;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroups() == null) ? 0 : logGroups().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsResponse)) {
            return false;
        }
        DescribeLogGroupsResponse other = (DescribeLogGroupsResponse) obj;
        if (other.logGroups() == null ^ this.logGroups() == null) {
            return false;
        }
        if (other.logGroups() != null && !other.logGroups().equals(this.logGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroups() != null) {
            sb.append("LogGroups: ").append(logGroups()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLogGroupsResponse> {
        /**
         * <p>
         * The log groups.
         * </p>
         * 
         * @param logGroups
         *        The log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(Collection<LogGroup> logGroups);

        /**
         * <p>
         * The log groups.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogGroups(java.util.Collection)} or {@link #withLogGroups(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param logGroups
         *        The log groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(LogGroup... logGroups);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<LogGroup> logGroups = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsResponse model) {
            setLogGroups(model.logGroups);
            setNextToken(model.nextToken);
        }

        public final Collection<LogGroup> getLogGroups() {
            return logGroups;
        }

        @Override
        public final Builder logGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroup... logGroups) {
            if (this.logGroups == null) {
                this.logGroups = new SdkInternalList<>(logGroups.length);
            }
            for (LogGroup e : logGroups) {
                this.logGroups.add(e);
            }
            return this;
        }

        public final void setLogGroups(Collection<LogGroup> logGroups) {
            this.logGroups = LogGroupsCopier.copy(logGroups);
        }

        @SafeVarargs
        public final void setLogGroups(LogGroup... logGroups) {
            if (this.logGroups == null) {
                this.logGroups = new SdkInternalList<>(logGroups.length);
            }
            for (LogGroup e : logGroups) {
                this.logGroups.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLogGroupsResponse build() {
            return new DescribeLogGroupsResponse(this);
        }
    }
}
