/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLogStreamsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeLogStreamsRequest.Builder, DescribeLogStreamsRequest> {
    private final String logGroupName;

    private final String logStreamNamePrefix;

    private final String orderBy;

    private final Boolean descending;

    private final String nextToken;

    private final Integer limit;

    private DescribeLogStreamsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.orderBy = builder.orderBy;
        this.descending = builder.descending;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The prefix to match.
     * </p>
     * <p>
     * You cannot specify this parameter if <code>orderBy</code> is <code>LastEventTime</code>.
     * </p>
     * 
     * @return The prefix to match.</p>
     *         <p>
     *         You cannot specify this parameter if <code>orderBy</code> is <code>LastEventTime</code>.
     */
    public String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    /**
     * <p>
     * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     * <code>LogStreamName</code>.
     * </p>
     * <p>
     * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
     * </p>
     * <p>
     * lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch Logs. This
     * number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTimeStamp updates on
     * an eventual consistency basis. It typically updates in less than an hour from ingestion, but may take longer in
     * some rare situations.
     * </p>
     * 
     * @return If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
     *         <code>LastEventTime</code>, the results are ordered by the event time. The default value is
     *         <code>LogStreamName</code>.</p>
     *         <p>
     *         If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
     *         parameter.
     *         </p>
     *         <p>
     *         lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch Logs.
     *         This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTimeStamp
     *         updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but
     *         may take longer in some rare situations.
     * @see OrderBy
     */
    public String orderBy() {
        return orderBy;
    }

    /**
     * <p>
     * If the value is true, results are returned in descending order. If the value is to false, results are returned in
     * ascending order. The default value is false.
     * </p>
     * 
     * @return If the value is true, results are returned in descending order. If the value is to false, results are
     *         returned in ascending order. The default value is false.
     */
    public Boolean descending() {
        return descending;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     * </p>
     * 
     * @return The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamNamePrefix() == null) ? 0 : logStreamNamePrefix().hashCode());
        hashCode = 31 * hashCode + ((orderBy() == null) ? 0 : orderBy().hashCode());
        hashCode = 31 * hashCode + ((descending() == null) ? 0 : descending().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsRequest)) {
            return false;
        }
        DescribeLogStreamsRequest other = (DescribeLogStreamsRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNamePrefix() == null ^ this.logStreamNamePrefix() == null) {
            return false;
        }
        if (other.logStreamNamePrefix() != null && !other.logStreamNamePrefix().equals(this.logStreamNamePrefix())) {
            return false;
        }
        if (other.orderBy() == null ^ this.orderBy() == null) {
            return false;
        }
        if (other.orderBy() != null && !other.orderBy().equals(this.orderBy())) {
            return false;
        }
        if (other.descending() == null ^ this.descending() == null) {
            return false;
        }
        if (other.descending() != null && !other.descending().equals(this.descending())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamNamePrefix() != null) {
            sb.append("LogStreamNamePrefix: ").append(logStreamNamePrefix()).append(",");
        }
        if (orderBy() != null) {
            sb.append("OrderBy: ").append(orderBy()).append(",");
        }
        if (descending() != null) {
            sb.append("Descending: ").append(descending()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLogStreamsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The prefix to match.
         * </p>
         * <p>
         * You cannot specify this parameter if <code>orderBy</code> is <code>LastEventTime</code>.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        The prefix to match.</p>
         *        <p>
         *        You cannot specify this parameter if <code>orderBy</code> is <code>LastEventTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);

        /**
         * <p>
         * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
         * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         * <code>LogStreamName</code>.
         * </p>
         * <p>
         * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
         * </p>
         * <p>
         * lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch Logs.
         * This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTimeStamp
         * updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but may
         * take longer in some rare situations.
         * </p>
         * 
         * @param orderBy
         *        If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value
         *        is <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         *        <code>LogStreamName</code>.</p>
         *        <p>
         *        If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
         *        parameter.
         *        </p>
         *        <p>
         *        lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch
         *        Logs. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        lastEventTimeStamp updates on an eventual consistency basis. It typically updates in less than an hour
         *        from ingestion, but may take longer in some rare situations.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is
         * <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         * <code>LogStreamName</code>.
         * </p>
         * <p>
         * If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.
         * </p>
         * <p>
         * lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch Logs.
         * This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTimeStamp
         * updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but may
         * take longer in some rare situations.
         * </p>
         * 
         * @param orderBy
         *        If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value
         *        is <code>LastEventTime</code>, the results are ordered by the event time. The default value is
         *        <code>LogStreamName</code>.</p>
         *        <p>
         *        If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code>
         *        parameter.
         *        </p>
         *        <p>
         *        lastEventTimestamp represents the time of the most recent log event in the log stream in CloudWatch
         *        Logs. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        lastEventTimeStamp updates on an eventual consistency basis. It typically updates in less than an hour
         *        from ingestion, but may take longer in some rare situations.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * If the value is true, results are returned in descending order. If the value is to false, results are
         * returned in ascending order. The default value is false.
         * </p>
         * 
         * @param descending
         *        If the value is true, results are returned in descending order. If the value is to false, results are
         *        returned in ascending order. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descending(Boolean descending);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * </p>
         * 
         * @param limit
         *        The maximum number of items returned. If you don't specify a value, the default is up to 50 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamNamePrefix;

        private String orderBy;

        private Boolean descending;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsRequest model) {
            setLogGroupName(model.logGroupName);
            setLogStreamNamePrefix(model.logStreamNamePrefix);
            setOrderBy(model.orderBy);
            setDescending(model.descending);
            setNextToken(model.nextToken);
            setLimit(model.limit);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public final void setOrderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
        }

        public final Boolean getDescending() {
            return descending;
        }

        @Override
        public final Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public final void setDescending(Boolean descending) {
            this.descending = descending;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DescribeLogStreamsRequest build() {
            return new DescribeLogStreamsRequest(this);
        }
    }
}
