/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLogStreamsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLogStreamsResponse.Builder, DescribeLogStreamsResponse> {
    private final List<LogStream> logStreams;

    private final String nextToken;

    private DescribeLogStreamsResponse(BuilderImpl builder) {
        this.logStreams = builder.logStreams;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The log streams.
     * </p>
     * 
     * @return The log streams.
     */
    public List<LogStream> logStreams() {
        return logStreams;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logStreams() == null) ? 0 : logStreams().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsResponse)) {
            return false;
        }
        DescribeLogStreamsResponse other = (DescribeLogStreamsResponse) obj;
        if (other.logStreams() == null ^ this.logStreams() == null) {
            return false;
        }
        if (other.logStreams() != null && !other.logStreams().equals(this.logStreams())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logStreams() != null) {
            sb.append("LogStreams: ").append(logStreams()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLogStreamsResponse> {
        /**
         * <p>
         * The log streams.
         * </p>
         * 
         * @param logStreams
         *        The log streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(Collection<LogStream> logStreams);

        /**
         * <p>
         * The log streams.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogStreams(java.util.Collection)} or {@link #withLogStreams(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param logStreams
         *        The log streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(LogStream... logStreams);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<LogStream> logStreams = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsResponse model) {
            setLogStreams(model.logStreams);
            setNextToken(model.nextToken);
        }

        public final Collection<LogStream> getLogStreams() {
            return logStreams;
        }

        @Override
        public final Builder logStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(LogStream... logStreams) {
            if (this.logStreams == null) {
                this.logStreams = new SdkInternalList<>(logStreams.length);
            }
            for (LogStream e : logStreams) {
                this.logStreams.add(e);
            }
            return this;
        }

        public final void setLogStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
        }

        @SafeVarargs
        public final void setLogStreams(LogStream... logStreams) {
            if (this.logStreams == null) {
                this.logStreams = new SdkInternalList<>(logStreams.length);
            }
            for (LogStream e : logStreams) {
                this.logStreams.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLogStreamsResponse build() {
            return new DescribeLogStreamsResponse(this);
        }
    }
}
