/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMetricFiltersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMetricFiltersResponse.Builder, DescribeMetricFiltersResponse> {
    private final List<MetricFilter> metricFilters;

    private final String nextToken;

    private DescribeMetricFiltersResponse(BuilderImpl builder) {
        this.metricFilters = builder.metricFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The metric filters.
     * </p>
     * 
     * @return The metric filters.
     */
    public List<MetricFilter> metricFilters() {
        return metricFilters;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricFilters() == null) ? 0 : metricFilters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersResponse)) {
            return false;
        }
        DescribeMetricFiltersResponse other = (DescribeMetricFiltersResponse) obj;
        if (other.metricFilters() == null ^ this.metricFilters() == null) {
            return false;
        }
        if (other.metricFilters() != null && !other.metricFilters().equals(this.metricFilters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricFilters() != null) {
            sb.append("MetricFilters: ").append(metricFilters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMetricFiltersResponse> {
        /**
         * <p>
         * The metric filters.
         * </p>
         * 
         * @param metricFilters
         *        The metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(Collection<MetricFilter> metricFilters);

        /**
         * <p>
         * The metric filters.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMetricFilters(java.util.Collection)} or {@link #withMetricFilters(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param metricFilters
         *        The metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(MetricFilter... metricFilters);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MetricFilter> metricFilters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersResponse model) {
            setMetricFilters(model.metricFilters);
            setNextToken(model.nextToken);
        }

        public final Collection<MetricFilter> getMetricFilters() {
            return metricFilters;
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilter... metricFilters) {
            if (this.metricFilters == null) {
                this.metricFilters = new SdkInternalList<>(metricFilters.length);
            }
            for (MetricFilter e : metricFilters) {
                this.metricFilters.add(e);
            }
            return this;
        }

        public final void setMetricFilters(Collection<MetricFilter> metricFilters) {
            this.metricFilters = MetricFiltersCopier.copy(metricFilters);
        }

        @SafeVarargs
        public final void setMetricFilters(MetricFilter... metricFilters) {
            if (this.metricFilters == null) {
                this.metricFilters = new SdkInternalList<>(metricFilters.length);
            }
            for (MetricFilter e : metricFilters) {
                this.metricFilters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMetricFiltersResponse build() {
            return new DescribeMetricFiltersResponse(this);
        }
    }
}
