/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubscriptionFiltersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeSubscriptionFiltersResponse.Builder, DescribeSubscriptionFiltersResponse> {
    private final List<SubscriptionFilter> subscriptionFilters;

    private final String nextToken;

    private DescribeSubscriptionFiltersResponse(BuilderImpl builder) {
        this.subscriptionFilters = builder.subscriptionFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The subscription filters.
     * </p>
     * 
     * @return The subscription filters.
     */
    public List<SubscriptionFilter> subscriptionFilters() {
        return subscriptionFilters;
    }

    /**
     *
     * @return
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subscriptionFilters() == null) ? 0 : subscriptionFilters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersResponse)) {
            return false;
        }
        DescribeSubscriptionFiltersResponse other = (DescribeSubscriptionFiltersResponse) obj;
        if (other.subscriptionFilters() == null ^ this.subscriptionFilters() == null) {
            return false;
        }
        if (other.subscriptionFilters() != null && !other.subscriptionFilters().equals(this.subscriptionFilters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subscriptionFilters() != null) {
            sb.append("SubscriptionFilters: ").append(subscriptionFilters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
        /**
         * <p>
         * The subscription filters.
         * </p>
         * 
         * @param subscriptionFilters
         *        The subscription filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters);

        /**
         * <p>
         * The subscription filters.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSubscriptionFilters(java.util.Collection)} or
         * {@link #withSubscriptionFilters(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param subscriptionFilters
         *        The subscription filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionFilters(SubscriptionFilter... subscriptionFilters);

        /**
         *
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<SubscriptionFilter> subscriptionFilters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersResponse model) {
            setSubscriptionFilters(model.subscriptionFilters);
            setNextToken(model.nextToken);
        }

        public final Collection<SubscriptionFilter> getSubscriptionFilters() {
            return subscriptionFilters;
        }

        @Override
        public final Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(SubscriptionFilter... subscriptionFilters) {
            if (this.subscriptionFilters == null) {
                this.subscriptionFilters = new SdkInternalList<>(subscriptionFilters.length);
            }
            for (SubscriptionFilter e : subscriptionFilters) {
                this.subscriptionFilters.add(e);
            }
            return this;
        }

        public final void setSubscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
        }

        @SafeVarargs
        public final void setSubscriptionFilters(SubscriptionFilter... subscriptionFilters) {
            if (this.subscriptionFilters == null) {
                this.subscriptionFilters = new SdkInternalList<>(subscriptionFilters.length);
            }
            for (SubscriptionFilter e : subscriptionFilters) {
                this.subscriptionFilters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscriptionFiltersResponse build() {
            return new DescribeSubscriptionFiltersResponse(this);
        }
    }
}
