/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DestinationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a cross-account destination that receives subscription log events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Destination implements StructuredPojo, ToCopyableBuilder<Destination.Builder, Destination> {
    private final String destinationName;

    private final String targetArn;

    private final String roleArn;

    private final String accessPolicy;

    private final String arn;

    private final Long creationTime;

    private Destination(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.accessPolicy = builder.accessPolicy;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the destination.
     * </p>
     * 
     * @return The name of the destination.
     */
    public String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the physical target where the log events will be delivered (for example, a
     * Kinesis stream).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the physical target where the log events will be delivered (for
     *         example, a Kinesis stream).
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * A role for impersonation, used when delivering log events to the target.
     * </p>
     * 
     * @return A role for impersonation, used when delivering log events to the target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An IAM policy document that governs which AWS accounts can create subscription filters against this destination.
     * </p>
     * 
     * @return An IAM policy document that governs which AWS accounts can create subscription filters against this
     *         destination.
     */
    public String accessPolicy() {
        return accessPolicy;
    }

    /**
     * <p>
     * The ARN of this destination.
     * </p>
     * 
     * @return The ARN of this destination.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The creation time of the destination, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the destination, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     *         UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationName() == null) ? 0 : destinationName().hashCode());
        hashCode = 31 * hashCode + ((targetArn() == null) ? 0 : targetArn().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((accessPolicy() == null) ? 0 : accessPolicy().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.accessPolicy() == null ^ this.accessPolicy() == null) {
            return false;
        }
        if (other.accessPolicy() != null && !other.accessPolicy().equals(this.accessPolicy())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationName() != null) {
            sb.append("DestinationName: ").append(destinationName()).append(",");
        }
        if (targetArn() != null) {
            sb.append("TargetArn: ").append(targetArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (accessPolicy() != null) {
            sb.append("AccessPolicy: ").append(accessPolicy()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * The name of the destination.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the physical target where the log events will be delivered (for example, a
         * Kinesis stream).
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the physical target where the log events will be delivered (for
         *        example, a Kinesis stream).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * A role for impersonation, used when delivering log events to the target.
         * </p>
         * 
         * @param roleArn
         *        A role for impersonation, used when delivering log events to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An IAM policy document that governs which AWS accounts can create subscription filters against this
         * destination.
         * </p>
         * 
         * @param accessPolicy
         *        An IAM policy document that governs which AWS accounts can create subscription filters against this
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);

        /**
         * <p>
         * The ARN of this destination.
         * </p>
         * 
         * @param arn
         *        The ARN of this destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The creation time of the destination, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the destination, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationName;

        private String targetArn;

        private String roleArn;

        private String accessPolicy;

        private String arn;

        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            setDestinationName(model.destinationName);
            setTargetArn(model.targetArn);
            setRoleArn(model.roleArn);
            setAccessPolicy(model.accessPolicy);
            setArn(model.arn);
            setCreationTime(model.creationTime);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }
    }
}
