/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ExportTaskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportTask implements StructuredPojo, ToCopyableBuilder<ExportTask.Builder, ExportTask> {
    private final String taskId;

    private final String taskName;

    private final String logGroupName;

    private final Long from;

    private final Long to;

    private final String destination;

    private final String destinationPrefix;

    private final ExportTaskStatus status;

    private final ExportTaskExecutionInfo executionInfo;

    private ExportTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
        this.status = builder.status;
        this.executionInfo = builder.executionInfo;
    }

    /**
     * <p>
     * The ID of the export task.
     * </p>
     * 
     * @return The ID of the export task.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The name of the export task.
     * </p>
     * 
     * @return The name of the export task.
     */
    public String taskName() {
        return taskName;
    }

    /**
     * <p>
     * The name of the log group from which logs data was exported.
     * </p>
     * 
     * @return The name of the log group from which logs data was exported.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The start time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a timestamp
     * prior to this time are not exported.
     * </p>
     * 
     * @return The start time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
     *         timestamp prior to this time are not exported.
     */
    public Long from() {
        return from;
    }

    /**
     * <p>
     * The end time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a timestamp
     * later than this time are not exported.
     * </p>
     * 
     * @return The end time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
     *         timestamp later than this time are not exported.
     */
    public Long to() {
        return to;
    }

    /**
     * <p>
     * The name of Amazon S3 bucket to which the log data was exported.
     * </p>
     * 
     * @return The name of Amazon S3 bucket to which the log data was exported.
     */
    public String destination() {
        return destination;
    }

    /**
     * <p>
     * The prefix that was used as the start of Amazon S3 key for every object exported.
     * </p>
     * 
     * @return The prefix that was used as the start of Amazon S3 key for every object exported.
     */
    public String destinationPrefix() {
        return destinationPrefix;
    }

    /**
     * <p>
     * The status of the export task.
     * </p>
     * 
     * @return The status of the export task.
     */
    public ExportTaskStatus status() {
        return status;
    }

    /**
     * <p>
     * Execution info about the export task.
     * </p>
     * 
     * @return Execution info about the export task.
     */
    public ExportTaskExecutionInfo executionInfo() {
        return executionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((taskId() == null) ? 0 : taskId().hashCode());
        hashCode = 31 * hashCode + ((taskName() == null) ? 0 : taskName().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((from() == null) ? 0 : from().hashCode());
        hashCode = 31 * hashCode + ((to() == null) ? 0 : to().hashCode());
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        hashCode = 31 * hashCode + ((destinationPrefix() == null) ? 0 : destinationPrefix().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((executionInfo() == null) ? 0 : executionInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask) obj;
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.taskName() == null ^ this.taskName() == null) {
            return false;
        }
        if (other.taskName() != null && !other.taskName().equals(this.taskName())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.from() == null ^ this.from() == null) {
            return false;
        }
        if (other.from() != null && !other.from().equals(this.from())) {
            return false;
        }
        if (other.to() == null ^ this.to() == null) {
            return false;
        }
        if (other.to() != null && !other.to().equals(this.to())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.destinationPrefix() == null ^ this.destinationPrefix() == null) {
            return false;
        }
        if (other.destinationPrefix() != null && !other.destinationPrefix().equals(this.destinationPrefix())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.executionInfo() == null ^ this.executionInfo() == null) {
            return false;
        }
        if (other.executionInfo() != null && !other.executionInfo().equals(this.executionInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (taskId() != null) {
            sb.append("TaskId: ").append(taskId()).append(",");
        }
        if (taskName() != null) {
            sb.append("TaskName: ").append(taskName()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (from() != null) {
            sb.append("From: ").append(from()).append(",");
        }
        if (to() != null) {
            sb.append("To: ").append(to()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (destinationPrefix() != null) {
            sb.append("DestinationPrefix: ").append(destinationPrefix()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (executionInfo() != null) {
            sb.append("ExecutionInfo: ").append(executionInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExportTask> {
        /**
         * <p>
         * The ID of the export task.
         * </p>
         * 
         * @param taskId
         *        The ID of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The name of the export task.
         * </p>
         * 
         * @param taskName
         *        The name of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskName(String taskName);

        /**
         * <p>
         * The name of the log group from which logs data was exported.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group from which logs data was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The start time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
         * timestamp prior to this time are not exported.
         * </p>
         * 
         * @param from
         *        The start time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
         *        timestamp prior to this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(Long from);

        /**
         * <p>
         * The end time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a timestamp
         * later than this time are not exported.
         * </p>
         * 
         * @param to
         *        The end time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
         *        timestamp later than this time are not exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Long to);

        /**
         * <p>
         * The name of Amazon S3 bucket to which the log data was exported.
         * </p>
         * 
         * @param destination
         *        The name of Amazon S3 bucket to which the log data was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The prefix that was used as the start of Amazon S3 key for every object exported.
         * </p>
         * 
         * @param destinationPrefix
         *        The prefix that was used as the start of Amazon S3 key for every object exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefix(String destinationPrefix);

        /**
         * <p>
         * The status of the export task.
         * </p>
         * 
         * @param status
         *        The status of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ExportTaskStatus status);

        /**
         * <p>
         * Execution info about the export task.
         * </p>
         * 
         * @param executionInfo
         *        Execution info about the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfo(ExportTaskExecutionInfo executionInfo);
    }

    private static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskName;

        private String logGroupName;

        private Long from;

        private Long to;

        private String destination;

        private String destinationPrefix;

        private ExportTaskStatus status;

        private ExportTaskExecutionInfo executionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            setTaskId(model.taskId);
            setTaskName(model.taskName);
            setLogGroupName(model.logGroupName);
            setFrom(model.from);
            setTo(model.to);
            setDestination(model.destination);
            setDestinationPrefix(model.destinationPrefix);
            setStatus(model.status);
            setExecutionInfo(model.executionInfo);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskName() {
            return taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getFrom() {
            return from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        public final ExportTaskStatus getStatus() {
            return status;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ExportTaskStatus status) {
            this.status = status;
        }

        public final ExportTaskExecutionInfo getExecutionInfo() {
            return executionInfo;
        }

        @Override
        public final Builder executionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
        }

        @Override
        public ExportTask build() {
            return new ExportTask(this);
        }
    }
}
