/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ExportTaskExecutionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the status of an export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportTaskExecutionInfo implements StructuredPojo,
        ToCopyableBuilder<ExportTaskExecutionInfo.Builder, ExportTaskExecutionInfo> {
    private final Long creationTime;

    private final Long completionTime;

    private ExportTaskExecutionInfo(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
    }

    /**
     * <p>
     * The creation time of the export task, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the export task, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     *         UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The completion time of the export task, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The completion time of the export task, expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC.
     */
    public Long completionTime() {
        return completionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((completionTime() == null) ? 0 : completionTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskExecutionInfo)) {
            return false;
        }
        ExportTaskExecutionInfo other = (ExportTaskExecutionInfo) obj;
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.completionTime() == null ^ this.completionTime() == null) {
            return false;
        }
        if (other.completionTime() != null && !other.completionTime().equals(this.completionTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (completionTime() != null) {
            sb.append("CompletionTime: ").append(completionTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTaskExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExportTaskExecutionInfo> {
        /**
         * <p>
         * The creation time of the export task, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the export task, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The completion time of the export task, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         * UTC.
         * </p>
         * 
         * @param completionTime
         *        The completion time of the export task, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Long completionTime);
    }

    private static final class BuilderImpl implements Builder {
        private Long creationTime;

        private Long completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskExecutionInfo model) {
            setCreationTime(model.creationTime);
            setCompletionTime(model.completionTime);
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getCompletionTime() {
            return completionTime;
        }

        @Override
        public final Builder completionTime(Long completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Long completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public ExportTaskExecutionInfo build() {
            return new ExportTaskExecutionInfo(this);
        }
    }
}
