/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class FilterLogEventsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<FilterLogEventsRequest.Builder, FilterLogEventsRequest> {
    private final String logGroupName;

    private final List<String> logStreamNames;

    private final Long startTime;

    private final Long endTime;

    private final String filterPattern;

    private final String nextToken;

    private final Integer limit;

    private final Boolean interleaved;

    private FilterLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNames = builder.logStreamNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filterPattern = builder.filterPattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.interleaved = builder.interleaved;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Optional list of log stream names.
     * </p>
     * 
     * @return Optional list of log stream names.
     */
    public List<String> logStreamNames() {
        return logStreamNames;
    }

    /**
     * <p>
     * The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with
     * a timestamp prior to this time are not returned.
     * </p>
     * 
     * @return The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     *         Events with a timestamp prior to this time are not returned.
     */
    public Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
     * timestamp later than this time are not returned.
     * </p>
     * 
     * @return The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
     *         with a timestamp later than this time are not returned.
     */
    public Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The filter pattern to use. If not provided, all the events are matched.
     * </p>
     * 
     * @return The filter pattern to use. If not provided, all the events are matched.
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The token for the next set of events to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of events to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of events to return. The default is 10,000 events.
     * </p>
     * 
     * @return The maximum number of events to return. The default is 10,000 events.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If the value is true, the operation makes a best effort to provide responses that contain events from multiple
     * log streams within the log group interleaved in a single response. If the value is false all the matched log
     * events in the first log stream are searched first, then those in the next log stream, and so on. The default is
     * false.
     * </p>
     * 
     * @return If the value is true, the operation makes a best effort to provide responses that contain events from
     *         multiple log streams within the log group interleaved in a single response. If the value is false all the
     *         matched log events in the first log stream are searched first, then those in the next log stream, and so
     *         on. The default is false.
     */
    public Boolean interleaved() {
        return interleaved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamNames() == null) ? 0 : logStreamNames().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((filterPattern() == null) ? 0 : filterPattern().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((interleaved() == null) ? 0 : interleaved().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamNames() == null ^ this.logStreamNames() == null) {
            return false;
        }
        if (other.logStreamNames() != null && !other.logStreamNames().equals(this.logStreamNames())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.interleaved() == null ^ this.interleaved() == null) {
            return false;
        }
        if (other.interleaved() != null && !other.interleaved().equals(this.interleaved())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamNames() != null) {
            sb.append("LogStreamNames: ").append(logStreamNames()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (filterPattern() != null) {
            sb.append("FilterPattern: ").append(filterPattern()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (interleaved() != null) {
            sb.append("Interleaved: ").append(interleaved()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, FilterLogEventsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Optional list of log stream names.
         * </p>
         * 
         * @param logStreamNames
         *        Optional list of log stream names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(Collection<String> logStreamNames);

        /**
         * <p>
         * Optional list of log stream names.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogStreamNames(java.util.Collection)} or {@link #withLogStreamNames(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param logStreamNames
         *        Optional list of log stream names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNames(String... logStreamNames);

        /**
         * <p>
         * The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp prior to this time are not returned.
         * </p>
         * 
         * @param startTime
         *        The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp prior to this time are not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp later than this time are not returned.
         * </p>
         * 
         * @param endTime
         *        The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp later than this time are not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The filter pattern to use. If not provided, all the events are matched.
         * </p>
         * 
         * @param filterPattern
         *        The filter pattern to use. If not provided, all the events are matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The token for the next set of events to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of events to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of events to return. The default is 10,000 events.
         * </p>
         * 
         * @param limit
         *        The maximum number of events to return. The default is 10,000 events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If the value is true, the operation makes a best effort to provide responses that contain events from
         * multiple log streams within the log group interleaved in a single response. If the value is false all the
         * matched log events in the first log stream are searched first, then those in the next log stream, and so on.
         * The default is false.
         * </p>
         * 
         * @param interleaved
         *        If the value is true, the operation makes a best effort to provide responses that contain events from
         *        multiple log streams within the log group interleaved in a single response. If the value is false all
         *        the matched log events in the first log stream are searched first, then those in the next log stream,
         *        and so on. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interleaved(Boolean interleaved);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private List<String> logStreamNames = new SdkInternalList<>();

        private Long startTime;

        private Long endTime;

        private String filterPattern;

        private String nextToken;

        private Integer limit;

        private Boolean interleaved;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsRequest model) {
            setLogGroupName(model.logGroupName);
            setLogStreamNames(model.logStreamNames);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setFilterPattern(model.filterPattern);
            setNextToken(model.nextToken);
            setLimit(model.limit);
            setInterleaved(model.interleaved);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getLogStreamNames() {
            return logStreamNames;
        }

        @Override
        public final Builder logStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreamNames(String... logStreamNames) {
            if (this.logStreamNames == null) {
                this.logStreamNames = new SdkInternalList<>(logStreamNames.length);
            }
            for (String e : logStreamNames) {
                this.logStreamNames.add(e);
            }
            return this;
        }

        public final void setLogStreamNames(Collection<String> logStreamNames) {
            this.logStreamNames = InputLogStreamNamesCopier.copy(logStreamNames);
        }

        @SafeVarargs
        public final void setLogStreamNames(String... logStreamNames) {
            if (this.logStreamNames == null) {
                this.logStreamNames = new SdkInternalList<>(logStreamNames.length);
            }
            for (String e : logStreamNames) {
                this.logStreamNames.add(e);
            }
        }

        public final Long getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getInterleaved() {
            return interleaved;
        }

        @Override
        public final Builder interleaved(Boolean interleaved) {
            this.interleaved = interleaved;
            return this;
        }

        public final void setInterleaved(Boolean interleaved) {
            this.interleaved = interleaved;
        }

        @Override
        public FilterLogEventsRequest build() {
            return new FilterLogEventsRequest(this);
        }
    }
}
