/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class FilterLogEventsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<FilterLogEventsResponse.Builder, FilterLogEventsResponse> {
    private final List<FilteredLogEvent> events;

    private final List<SearchedLogStream> searchedLogStreams;

    private final String nextToken;

    private FilterLogEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.searchedLogStreams = builder.searchedLogStreams;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The matched events.
     * </p>
     * 
     * @return The matched events.
     */
    public List<FilteredLogEvent> events() {
        return events;
    }

    /**
     * <p>
     * Indicates which log streams have been searched and whether each has been searched completely.
     * </p>
     * 
     * @return Indicates which log streams have been searched and whether each has been searched completely.
     */
    public List<SearchedLogStream> searchedLogStreams() {
        return searchedLogStreams;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. The token expires after 24 hours.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. The token expires after 24 hours.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((searchedLogStreams() == null) ? 0 : searchedLogStreams().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResponse)) {
            return false;
        }
        FilterLogEventsResponse other = (FilterLogEventsResponse) obj;
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.searchedLogStreams() == null ^ this.searchedLogStreams() == null) {
            return false;
        }
        if (other.searchedLogStreams() != null && !other.searchedLogStreams().equals(this.searchedLogStreams())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (searchedLogStreams() != null) {
            sb.append("SearchedLogStreams: ").append(searchedLogStreams()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, FilterLogEventsResponse> {
        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param events
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<FilteredLogEvent> events);

        /**
         * <p>
         * The matched events.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(FilteredLogEvent... events);

        /**
         * <p>
         * Indicates which log streams have been searched and whether each has been searched completely.
         * </p>
         * 
         * @param searchedLogStreams
         *        Indicates which log streams have been searched and whether each has been searched completely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams);

        /**
         * <p>
         * Indicates which log streams have been searched and whether each has been searched completely.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSearchedLogStreams(java.util.Collection)} or {@link #withSearchedLogStreams(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param searchedLogStreams
         *        Indicates which log streams have been searched and whether each has been searched completely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedLogStreams(SearchedLogStream... searchedLogStreams);

        /**
         * <p>
         * The token to use when requesting the next set of items. The token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. The token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<FilteredLogEvent> events = new SdkInternalList<>();

        private List<SearchedLogStream> searchedLogStreams = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsResponse model) {
            setEvents(model.events);
            setSearchedLogStreams(model.searchedLogStreams);
            setNextToken(model.nextToken);
        }

        public final Collection<FilteredLogEvent> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(FilteredLogEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (FilteredLogEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(FilteredLogEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (FilteredLogEvent e : events) {
                this.events.add(e);
            }
        }

        public final Collection<SearchedLogStream> getSearchedLogStreams() {
            return searchedLogStreams;
        }

        @Override
        public final Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(SearchedLogStream... searchedLogStreams) {
            if (this.searchedLogStreams == null) {
                this.searchedLogStreams = new SdkInternalList<>(searchedLogStreams.length);
            }
            for (SearchedLogStream e : searchedLogStreams) {
                this.searchedLogStreams.add(e);
            }
            return this;
        }

        public final void setSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
        }

        @SafeVarargs
        public final void setSearchedLogStreams(SearchedLogStream... searchedLogStreams) {
            if (this.searchedLogStreams == null) {
                this.searchedLogStreams = new SdkInternalList<>(searchedLogStreams.length);
            }
            for (SearchedLogStream e : searchedLogStreams) {
                this.searchedLogStreams.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public FilterLogEventsResponse build() {
            return new FilterLogEventsResponse(this);
        }
    }
}
