/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.FilteredLogEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a matched event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FilteredLogEvent implements StructuredPojo, ToCopyableBuilder<FilteredLogEvent.Builder, FilteredLogEvent> {
    private final String logStreamName;

    private final Long timestamp;

    private final String message;

    private final Long ingestionTime;

    private final String eventId;

    private FilteredLogEvent(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
        this.eventId = builder.eventId;
    }

    /**
     * <p>
     * The name of the log stream this event belongs to.
     * </p>
     * 
     * @return The name of the log stream this event belongs to.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The data contained in the log event.
     * </p>
     * 
     * @return The data contained in the log event.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The time the event was ingested, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time the event was ingested, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long ingestionTime() {
        return ingestionTime;
    }

    /**
     * <p>
     * The ID of the event.
     * </p>
     * 
     * @return The ID of the event.
     */
    public String eventId() {
        return eventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((ingestionTime() == null) ? 0 : ingestionTime().hashCode());
        hashCode = 31 * hashCode + ((eventId() == null) ? 0 : eventId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilteredLogEvent)) {
            return false;
        }
        FilteredLogEvent other = (FilteredLogEvent) obj;
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.ingestionTime() == null ^ this.ingestionTime() == null) {
            return false;
        }
        if (other.ingestionTime() != null && !other.ingestionTime().equals(this.ingestionTime())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (ingestionTime() != null) {
            sb.append("IngestionTime: ").append(ingestionTime()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilteredLogEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FilteredLogEvent> {
        /**
         * <p>
         * The name of the log stream this event belongs to.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream this event belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param timestamp
         *        The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The data contained in the log event.
         * </p>
         * 
         * @param message
         *        The data contained in the log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time the event was ingested, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param ingestionTime
         *        The time the event was ingested, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionTime(Long ingestionTime);

        /**
         * <p>
         * The ID of the event.
         * </p>
         * 
         * @param eventId
         *        The ID of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);
    }

    private static final class BuilderImpl implements Builder {
        private String logStreamName;

        private Long timestamp;

        private String message;

        private Long ingestionTime;

        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(FilteredLogEvent model) {
            setLogStreamName(model.logStreamName);
            setTimestamp(model.timestamp);
            setMessage(model.message);
            setIngestionTime(model.ingestionTime);
            setEventId(model.eventId);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getIngestionTime() {
            return ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public FilteredLogEvent build() {
            return new FilteredLogEvent(this);
        }
    }
}
