/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetLogEventsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetLogEventsRequest.Builder, GetLogEventsRequest> {
    private final String logGroupName;

    private final String logStreamName;

    private final Long startTime;

    private final Long endTime;

    private final String nextToken;

    private final Integer limit;

    private final Boolean startFromHead;

    private GetLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.startFromHead = builder.startFromHead;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with
     * a timestamp earlier than this time are not included.
     * </p>
     * 
     * @return The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     *         Events with a timestamp earlier than this time are not included.
     */
    public Long startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events with a
     * timestamp later than this time are not included.
     * </p>
     * 
     * @return The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
     *         with a timestamp later than this time are not included.
     */
    public Long endTime() {
        return endTime;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can
     * fit in a response size of 1MB, up to 10,000 log events.
     * </p>
     * 
     * @return The maximum number of log events returned. If you don't specify a value, the maximum is as many log
     *         events as can fit in a response size of 1MB, up to 10,000 log events.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * If the value is true, the earliest log events are returned first. If the value is false, the latest log events
     * are returned first. The default value is false.
     * </p>
     * 
     * @return If the value is true, the earliest log events are returned first. If the value is false, the latest log
     *         events are returned first. The default value is false.
     */
    public Boolean startFromHead() {
        return startFromHead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((startFromHead() == null) ? 0 : startFromHead().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsRequest)) {
            return false;
        }
        GetLogEventsRequest other = (GetLogEventsRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.startFromHead() == null ^ this.startFromHead() == null) {
            return false;
        }
        if (other.startFromHead() != null && !other.startFromHead().equals(this.startFromHead())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (startFromHead() != null) {
            sb.append("StartFromHead: ").append(startFromHead()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetLogEventsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp earlier than this time are not included.
         * </p>
         * 
         * @param startTime
         *        The start of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp earlier than this time are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Long startTime);

        /**
         * <p>
         * The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. Events
         * with a timestamp later than this time are not included.
         * </p>
         * 
         * @param endTime
         *        The end of the time range, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         *        Events with a timestamp later than this time are not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Long endTime);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as
         * can fit in a response size of 1MB, up to 10,000 log events.
         * </p>
         * 
         * @param limit
         *        The maximum number of log events returned. If you don't specify a value, the maximum is as many log
         *        events as can fit in a response size of 1MB, up to 10,000 log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * If the value is true, the earliest log events are returned first. If the value is false, the latest log
         * events are returned first. The default value is false.
         * </p>
         * 
         * @param startFromHead
         *        If the value is true, the earliest log events are returned first. If the value is false, the latest
         *        log events are returned first. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFromHead(Boolean startFromHead);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamName;

        private Long startTime;

        private Long endTime;

        private String nextToken;

        private Integer limit;

        private Boolean startFromHead;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsRequest model) {
            setLogGroupName(model.logGroupName);
            setLogStreamName(model.logStreamName);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setNextToken(model.nextToken);
            setLimit(model.limit);
            setStartFromHead(model.startFromHead);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public final Long getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getStartFromHead() {
            return startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        @Override
        public GetLogEventsRequest build() {
            return new GetLogEventsRequest(this);
        }
    }
}
