/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetLogEventsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetLogEventsResponse.Builder, GetLogEventsResponse> {
    private final List<OutputLogEvent> events;

    private final String nextForwardToken;

    private final String nextBackwardToken;

    private GetLogEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextForwardToken = builder.nextForwardToken;
        this.nextBackwardToken = builder.nextBackwardToken;
    }

    /**
     * <p>
     * The events.
     * </p>
     * 
     * @return The events.
     */
    public List<OutputLogEvent> events() {
        return events;
    }

    /**
     * <p>
     * The token for the next set of items in the forward direction. The token expires after 24 hours.
     * </p>
     * 
     * @return The token for the next set of items in the forward direction. The token expires after 24 hours.
     */
    public String nextForwardToken() {
        return nextForwardToken;
    }

    /**
     * <p>
     * The token for the next set of items in the backward direction. The token expires after 24 hours.
     * </p>
     * 
     * @return The token for the next set of items in the backward direction. The token expires after 24 hours.
     */
    public String nextBackwardToken() {
        return nextBackwardToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((nextForwardToken() == null) ? 0 : nextForwardToken().hashCode());
        hashCode = 31 * hashCode + ((nextBackwardToken() == null) ? 0 : nextBackwardToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResponse)) {
            return false;
        }
        GetLogEventsResponse other = (GetLogEventsResponse) obj;
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.nextForwardToken() == null ^ this.nextForwardToken() == null) {
            return false;
        }
        if (other.nextForwardToken() != null && !other.nextForwardToken().equals(this.nextForwardToken())) {
            return false;
        }
        if (other.nextBackwardToken() == null ^ this.nextBackwardToken() == null) {
            return false;
        }
        if (other.nextBackwardToken() != null && !other.nextBackwardToken().equals(this.nextBackwardToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (nextForwardToken() != null) {
            sb.append("NextForwardToken: ").append(nextForwardToken()).append(",");
        }
        if (nextBackwardToken() != null) {
            sb.append("NextBackwardToken: ").append(nextBackwardToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetLogEventsResponse> {
        /**
         * <p>
         * The events.
         * </p>
         * 
         * @param events
         *        The events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<OutputLogEvent> events);

        /**
         * <p>
         * The events.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         *        The events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(OutputLogEvent... events);

        /**
         * <p>
         * The token for the next set of items in the forward direction. The token expires after 24 hours.
         * </p>
         * 
         * @param nextForwardToken
         *        The token for the next set of items in the forward direction. The token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextForwardToken(String nextForwardToken);

        /**
         * <p>
         * The token for the next set of items in the backward direction. The token expires after 24 hours.
         * </p>
         * 
         * @param nextBackwardToken
         *        The token for the next set of items in the backward direction. The token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextBackwardToken(String nextBackwardToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<OutputLogEvent> events = new SdkInternalList<>();

        private String nextForwardToken;

        private String nextBackwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsResponse model) {
            setEvents(model.events);
            setNextForwardToken(model.nextForwardToken);
            setNextBackwardToken(model.nextBackwardToken);
        }

        public final Collection<OutputLogEvent> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(OutputLogEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (OutputLogEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(OutputLogEvent... events) {
            if (this.events == null) {
                this.events = new SdkInternalList<>(events.length);
            }
            for (OutputLogEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getNextForwardToken() {
            return nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        public final String getNextBackwardToken() {
            return nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public GetLogEventsResponse build() {
            return new GetLogEventsResponse(this);
        }
    }
}
