/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.InputLogEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log event, which is a record of activity that was recorded by the application or resource being
 * monitored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputLogEvent implements StructuredPojo, ToCopyableBuilder<InputLogEvent.Builder, InputLogEvent> {
    private final Long timestamp;

    private final String message;

    private InputLogEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
    }

    /**
     * <p>
     * The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The raw event message.
     * </p>
     * 
     * @return The raw event message.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLogEvent)) {
            return false;
        }
        InputLogEvent other = (InputLogEvent) obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLogEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputLogEvent> {
        /**
         * <p>
         * The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param timestamp
         *        The time the event occurred, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The raw event message.
         * </p>
         * 
         * @param message
         *        The raw event message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private Long timestamp;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLogEvent model) {
            setTimestamp(model.timestamp);
            setMessage(model.message);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public InputLogEvent build() {
            return new InputLogEvent(this);
        }
    }
}
