/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sequence token is not valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidSequenceTokenException extends CloudWatchLogsException implements
        ToCopyableBuilder<InvalidSequenceTokenException.Builder, InvalidSequenceTokenException> {
    private final String expectedSequenceToken;

    private InvalidSequenceTokenException(BuilderImpl builder) {
        super(builder.message);
        this.expectedSequenceToken = builder.expectedSequenceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     *
     * @return
     */
    public String expectedSequenceToken() {
        return expectedSequenceToken;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidSequenceTokenException> {
        /**
         *
         * @param expectedSequenceToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedSequenceToken(String expectedSequenceToken);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String expectedSequenceToken;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSequenceTokenException model) {
            setExpectedSequenceToken(model.expectedSequenceToken);
            this.message = model.getMessage();
        }

        public final String getExpectedSequenceToken() {
            return expectedSequenceToken;
        }

        @Override
        public final Builder expectedSequenceToken(String expectedSequenceToken) {
            this.expectedSequenceToken = expectedSequenceToken;
            return this;
        }

        @JsonProperty("expectedSequenceToken")
        public final void setExpectedSequenceToken(String expectedSequenceToken) {
            this.expectedSequenceToken = expectedSequenceToken;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidSequenceTokenException build() {
            return new InvalidSequenceTokenException(this);
        }
    }
}
