/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogGroupMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LogGroup implements StructuredPojo, ToCopyableBuilder<LogGroup.Builder, LogGroup> {
    private final String logGroupName;

    private final Long creationTime;

    private final Integer retentionInDays;

    private final Integer metricFilterCount;

    private final String arn;

    private final Long storedBytes;

    private LogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.creationTime = builder.creationTime;
        this.retentionInDays = builder.retentionInDays;
        this.metricFilterCount = builder.metricFilterCount;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The creation time of the log group, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the log group, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     *         UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    /**
     *
     * @return
     */
    public Integer retentionInDays() {
        return retentionInDays;
    }

    /**
     * <p>
     * The number of metric filters.
     * </p>
     * 
     * @return The number of metric filters.
     */
    public Integer metricFilterCount() {
        return metricFilterCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log group.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of bytes stored.
     * </p>
     * 
     * @return The number of bytes stored.
     */
    public Long storedBytes() {
        return storedBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((retentionInDays() == null) ? 0 : retentionInDays().hashCode());
        hashCode = 31 * hashCode + ((metricFilterCount() == null) ? 0 : metricFilterCount().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((storedBytes() == null) ? 0 : storedBytes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogGroup)) {
            return false;
        }
        LogGroup other = (LogGroup) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.retentionInDays() == null ^ this.retentionInDays() == null) {
            return false;
        }
        if (other.retentionInDays() != null && !other.retentionInDays().equals(this.retentionInDays())) {
            return false;
        }
        if (other.metricFilterCount() == null ^ this.metricFilterCount() == null) {
            return false;
        }
        if (other.metricFilterCount() != null && !other.metricFilterCount().equals(this.metricFilterCount())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.storedBytes() == null ^ this.storedBytes() == null) {
            return false;
        }
        if (other.storedBytes() != null && !other.storedBytes().equals(this.storedBytes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (retentionInDays() != null) {
            sb.append("RetentionInDays: ").append(retentionInDays()).append(",");
        }
        if (metricFilterCount() != null) {
            sb.append("MetricFilterCount: ").append(metricFilterCount()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (storedBytes() != null) {
            sb.append("StoredBytes: ").append(storedBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LogGroup> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The creation time of the log group, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the log group, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         *
         * @param retentionInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Integer retentionInDays);

        /**
         * <p>
         * The number of metric filters.
         * </p>
         * 
         * @param metricFilterCount
         *        The number of metric filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilterCount(Integer metricFilterCount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of bytes stored.
         * </p>
         * 
         * @param storedBytes
         *        The number of bytes stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedBytes(Long storedBytes);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private Long creationTime;

        private Integer retentionInDays;

        private Integer metricFilterCount;

        private String arn;

        private Long storedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(LogGroup model) {
            setLogGroupName(model.logGroupName);
            setCreationTime(model.creationTime);
            setRetentionInDays(model.retentionInDays);
            setMetricFilterCount(model.metricFilterCount);
            setArn(model.arn);
            setStoredBytes(model.storedBytes);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRetentionInDays() {
            return retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        public final Integer getMetricFilterCount() {
            return metricFilterCount;
        }

        @Override
        public final Builder metricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
            return this;
        }

        public final void setMetricFilterCount(Integer metricFilterCount) {
            this.metricFilterCount = metricFilterCount;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        @Override
        public LogGroup build() {
            return new LogGroup(this);
        }
    }
}
