/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.LogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log stream, which is a sequence of log events from a single emitter of logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LogStream implements StructuredPojo, ToCopyableBuilder<LogStream.Builder, LogStream> {
    private final String logStreamName;

    private final Long creationTime;

    private final Long firstEventTimestamp;

    private final Long lastEventTimestamp;

    private final Long lastIngestionTime;

    private final String uploadSequenceToken;

    private final String arn;

    private final Long storedBytes;

    private LogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.creationTime = builder.creationTime;
        this.firstEventTimestamp = builder.firstEventTimestamp;
        this.lastEventTimestamp = builder.lastEventTimestamp;
        this.lastIngestionTime = builder.lastIngestionTime;
        this.uploadSequenceToken = builder.uploadSequenceToken;
        this.arn = builder.arn;
        this.storedBytes = builder.storedBytes;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The creation time of the stream, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the stream, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time of the first event, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The time of the first event, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long firstEventTimestamp() {
        return firstEventTimestamp;
    }

    /**
     * <p>
     * the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the
     * number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTime updates on an eventual consistency basis. It
     * typically updates in less than an hour from ingestion, but may take longer in some rare situations.
     * </p>
     * 
     * @return the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as
     *         the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTime updates on an eventual
     *         consistency basis. It typically updates in less than an hour from ingestion, but may take longer in some
     *         rare situations.
     */
    public Long lastEventTimestamp() {
        return lastEventTimestamp;
    }

    /**
     * <p>
     * The ingestion time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The ingestion time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     */
    public Long lastIngestionTime() {
        return lastIngestionTime;
    }

    /**
     * <p>
     * The sequence token.
     * </p>
     * 
     * @return The sequence token.
     */
    public String uploadSequenceToken() {
        return uploadSequenceToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log stream.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of bytes stored.
     * </p>
     * 
     * @return The number of bytes stored.
     */
    public Long storedBytes() {
        return storedBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((firstEventTimestamp() == null) ? 0 : firstEventTimestamp().hashCode());
        hashCode = 31 * hashCode + ((lastEventTimestamp() == null) ? 0 : lastEventTimestamp().hashCode());
        hashCode = 31 * hashCode + ((lastIngestionTime() == null) ? 0 : lastIngestionTime().hashCode());
        hashCode = 31 * hashCode + ((uploadSequenceToken() == null) ? 0 : uploadSequenceToken().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((storedBytes() == null) ? 0 : storedBytes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogStream)) {
            return false;
        }
        LogStream other = (LogStream) obj;
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.firstEventTimestamp() == null ^ this.firstEventTimestamp() == null) {
            return false;
        }
        if (other.firstEventTimestamp() != null && !other.firstEventTimestamp().equals(this.firstEventTimestamp())) {
            return false;
        }
        if (other.lastEventTimestamp() == null ^ this.lastEventTimestamp() == null) {
            return false;
        }
        if (other.lastEventTimestamp() != null && !other.lastEventTimestamp().equals(this.lastEventTimestamp())) {
            return false;
        }
        if (other.lastIngestionTime() == null ^ this.lastIngestionTime() == null) {
            return false;
        }
        if (other.lastIngestionTime() != null && !other.lastIngestionTime().equals(this.lastIngestionTime())) {
            return false;
        }
        if (other.uploadSequenceToken() == null ^ this.uploadSequenceToken() == null) {
            return false;
        }
        if (other.uploadSequenceToken() != null && !other.uploadSequenceToken().equals(this.uploadSequenceToken())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.storedBytes() == null ^ this.storedBytes() == null) {
            return false;
        }
        if (other.storedBytes() != null && !other.storedBytes().equals(this.storedBytes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (firstEventTimestamp() != null) {
            sb.append("FirstEventTimestamp: ").append(firstEventTimestamp()).append(",");
        }
        if (lastEventTimestamp() != null) {
            sb.append("LastEventTimestamp: ").append(lastEventTimestamp()).append(",");
        }
        if (lastIngestionTime() != null) {
            sb.append("LastIngestionTime: ").append(lastIngestionTime()).append(",");
        }
        if (uploadSequenceToken() != null) {
            sb.append("UploadSequenceToken: ").append(uploadSequenceToken()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (storedBytes() != null) {
            sb.append("StoredBytes: ").append(storedBytes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LogStream> {
        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The creation time of the stream, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the stream, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         *        UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The time of the first event, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param firstEventTimestamp
         *        The time of the first event, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstEventTimestamp(Long firstEventTimestamp);

        /**
         * <p>
         * the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the
         * number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTime updates on an eventual consistency
         * basis. It typically updates in less than an hour from ingestion, but may take longer in some rare situations.
         * </p>
         * 
         * @param lastEventTimestamp
         *        the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed
         *        as the number of milliseconds since Jan 1, 1970 00:00:00 UTC. lastEventTime updates on an eventual
         *        consistency basis. It typically updates in less than an hour from ingestion, but may take longer in
         *        some rare situations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEventTimestamp(Long lastEventTimestamp);

        /**
         * <p>
         * The ingestion time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * </p>
         * 
         * @param lastIngestionTime
         *        The ingestion time, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIngestionTime(Long lastIngestionTime);

        /**
         * <p>
         * The sequence token.
         * </p>
         * 
         * @param uploadSequenceToken
         *        The sequence token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSequenceToken(String uploadSequenceToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log stream.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of bytes stored.
         * </p>
         * 
         * @param storedBytes
         *        The number of bytes stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedBytes(Long storedBytes);
    }

    private static final class BuilderImpl implements Builder {
        private String logStreamName;

        private Long creationTime;

        private Long firstEventTimestamp;

        private Long lastEventTimestamp;

        private Long lastIngestionTime;

        private String uploadSequenceToken;

        private String arn;

        private Long storedBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(LogStream model) {
            setLogStreamName(model.logStreamName);
            setCreationTime(model.creationTime);
            setFirstEventTimestamp(model.firstEventTimestamp);
            setLastEventTimestamp(model.lastEventTimestamp);
            setLastIngestionTime(model.lastIngestionTime);
            setUploadSequenceToken(model.uploadSequenceToken);
            setArn(model.arn);
            setStoredBytes(model.storedBytes);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getFirstEventTimestamp() {
            return firstEventTimestamp;
        }

        @Override
        public final Builder firstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
            return this;
        }

        public final void setFirstEventTimestamp(Long firstEventTimestamp) {
            this.firstEventTimestamp = firstEventTimestamp;
        }

        public final Long getLastEventTimestamp() {
            return lastEventTimestamp;
        }

        @Override
        public final Builder lastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
            return this;
        }

        public final void setLastEventTimestamp(Long lastEventTimestamp) {
            this.lastEventTimestamp = lastEventTimestamp;
        }

        public final Long getLastIngestionTime() {
            return lastIngestionTime;
        }

        @Override
        public final Builder lastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
            return this;
        }

        public final void setLastIngestionTime(Long lastIngestionTime) {
            this.lastIngestionTime = lastIngestionTime;
        }

        public final String getUploadSequenceToken() {
            return uploadSequenceToken;
        }

        @Override
        public final Builder uploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
            return this;
        }

        public final void setUploadSequenceToken(String uploadSequenceToken) {
            this.uploadSequenceToken = uploadSequenceToken;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getStoredBytes() {
            return storedBytes;
        }

        @Override
        public final Builder storedBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
            return this;
        }

        public final void setStoredBytes(Long storedBytes) {
            this.storedBytes = storedBytes;
        }

        @Override
        public LogStream build() {
            return new LogStream(this);
        }
    }
}
